/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import com.facebook.presto.hive.$internal.com.google.common.collect.ImmutableList;
import com.facebook.presto.hive.$internal.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.RelOptHiveTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.plan.ColStatistics;

public class HiveTableScan
extends TableScan
implements HiveRelNode {
    private final RelDataType hiveTableScanRowType;
    private final ImmutableList<Integer> neededColIndxsFrmReloptHT;
    private final String tblAlias;
    private final String concatQbIDAlias;
    private final boolean useQBIdInDigest;

    public String getTableAlias() {
        return this.tblAlias;
    }

    public String getConcatQbIDAlias() {
        return this.concatQbIDAlias;
    }

    public HiveTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptHiveTable table, String alias, String concatQbIDAlias, boolean useQBIdInDigest) {
        this(cluster, traitSet, table, alias, concatQbIDAlias, table.getRowType(), useQBIdInDigest);
    }

    private HiveTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptHiveTable table, String alias, String concatQbIDAlias, RelDataType newRowtype, boolean useQBIdInDigest) {
        super(cluster, TraitsUtil.getDefaultTraitSet(cluster), (RelOptTable)table);
        assert (this.getConvention() == HiveRelNode.CONVENTION);
        this.tblAlias = alias;
        this.concatQbIDAlias = concatQbIDAlias;
        this.hiveTableScanRowType = newRowtype;
        this.neededColIndxsFrmReloptHT = HiveTableScan.buildNeededColIndxsFrmReloptHT(table.getRowType(), newRowtype);
        this.useQBIdInDigest = useQBIdInDigest;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    public HiveTableScan copy(RelDataType newRowtype) {
        return new HiveTableScan(this.getCluster(), this.getTraitSet(), (RelOptHiveTable)this.table, this.tblAlias, this.concatQbIDAlias, newRowtype, this.useQBIdInDigest);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return RelMetadataQuery.getNonCumulativeCost((RelNode)this);
    }

    public RelWriter explainTerms(RelWriter pw) {
        if (this.useQBIdInDigest) {
            return super.explainTerms(pw).item("qbid:alias", (Object)this.concatQbIDAlias);
        }
        return super.explainTerms(pw);
    }

    public void register(RelOptPlanner planner) {
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    public double getRows() {
        return ((RelOptHiveTable)this.table).getRowCount();
    }

    public List<ColStatistics> getColStat(List<Integer> projIndxLst) {
        return ((RelOptHiveTable)this.table).getColStat(projIndxLst);
    }

    public RelNode project(ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields, RelFactories.ProjectFactory projectFactory) {
        int fieldCount = this.getRowType().getFieldCount();
        if (fieldsUsed.equals((Object)ImmutableBitSet.range((int)fieldCount)) && extraFields.isEmpty()) {
            return this;
        }
        if (extraFields != null && !extraFields.isEmpty()) {
            throw new RuntimeException("Hive TS does not support adding virtual columns dynamically");
        }
        List fields = this.getRowType().getFieldList();
        LinkedList<RelDataType> fieldTypes = new LinkedList<RelDataType>();
        LinkedList<String> fieldNames = new LinkedList<String>();
        ArrayList<RexInputRef> exprList = new ArrayList<RexInputRef>();
        RexBuilder rexBuilder = this.getCluster().getRexBuilder();
        Iterator i$ = fieldsUsed.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            RelDataTypeField field = (RelDataTypeField)fields.get(i);
            fieldTypes.add(field.getType());
            fieldNames.add(field.getName());
            exprList.add(rexBuilder.makeInputRef((RelNode)this, i));
        }
        HiveTableScan newHT = this.copy(this.getCluster().getTypeFactory().createStructType(fieldTypes, fieldNames));
        return projectFactory.createProject((RelNode)newHT, exprList, new ArrayList(fieldNames));
    }

    public List<Integer> getNeededColIndxsFrmReloptHT() {
        return this.neededColIndxsFrmReloptHT;
    }

    public RelDataType getPrunedRowType() {
        return this.hiveTableScanRowType;
    }

    private static ImmutableList<Integer> buildNeededColIndxsFrmReloptHT(RelDataType htRowtype, RelDataType scanRowType) {
        ImmutableList.Builder neededColIndxsFrmReloptHTBldr = new ImmutableList.Builder();
        ImmutableMap<String, Integer> colNameToPosInReloptHT = HiveCalciteUtil.getRowColNameIndxMap(htRowtype.getFieldList());
        List colNamesInScanRowType = scanRowType.getFieldNames();
        for (int i = 0; i < colNamesInScanRowType.size(); ++i) {
            neededColIndxsFrmReloptHTBldr.add(colNameToPosInReloptHT.get(colNamesInScanRowType.get(i)));
        }
        return neededColIndxsFrmReloptHTBldr.build();
    }
}

