/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.objectinspector;

import com.facebook.presto.hive.$internal.com.google.common.primitives.UnsignedBytes;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ReflectionStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.ThriftObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.TUnion;
import org.apache.thrift.meta_data.FieldMetaData;

public class ThriftUnionObjectInspector
extends ReflectionStructObjectInspector
implements UnionObjectInspector {
    private static final String FIELD_METADATA_MAP = "metaDataMap";
    private List<ObjectInspector> ois;

    @Override
    public boolean shouldIgnoreField(String name) {
        return name.startsWith("__isset");
    }

    @Override
    public List<ObjectInspector> getObjectInspectors() {
        return this.ois;
    }

    @Override
    public byte getTag(Object o) {
        if (o == null) {
            return -1;
        }
        TFieldIdEnum setField = ((TUnion)o).getSetField();
        return UnsignedBytes.checkedCast(setField.getThriftFieldId() - 1);
    }

    @Override
    public Object getField(Object o) {
        if (o == null) {
            return null;
        }
        return ((TUnion)o).getFieldValue();
    }

    @Override
    protected void init(Class<?> objectClass, ObjectInspectorFactory.ObjectInspectorOptions options) {
        Field fieldMetaData;
        this.verifyObjectClassType(objectClass);
        this.objectClass = objectClass;
        try {
            fieldMetaData = objectClass.getDeclaredField(FIELD_METADATA_MAP);
            assert (Map.class.isAssignableFrom(fieldMetaData.getType()));
            fieldMetaData.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Unable to find field metadata for thrift union field ", e);
        }
        try {
            Map fieldMap = (Map)fieldMetaData.get(null);
            this.ois = new ArrayList<ObjectInspector>();
            for (Map.Entry metadata : fieldMap.entrySet()) {
                Type fieldType = ThriftObjectInspectorUtils.getFieldType(objectClass, ((FieldMetaData)metadata.getValue()).fieldName);
                ObjectInspector reflectionObjectInspector = ObjectInspectorFactory.getReflectionObjectInspector(fieldType, options);
                this.ois.add(reflectionObjectInspector);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to find field metadata for thrift union field ", e);
        }
    }

    @Override
    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.UNION;
    }

    @Override
    public List<? extends StructField> getAllStructFieldRefs() {
        return this.fields;
    }

    @Override
    public String getTypeName() {
        return ObjectInspectorUtils.getStandardUnionTypeName(this);
    }

    @Override
    public Object create() {
        return ReflectionUtils.newInstance((Class)this.objectClass, null);
    }
}

