/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.ArrayBlock;
import com.facebook.presto.spi.block.ArrayBlockEncoding;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockEncoding;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.airlift.slice.Slices;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractArrayBlock
implements Block {
    protected abstract Block getValues();

    protected abstract Slice getOffsets();

    protected abstract int getOffsetBase();

    protected abstract Slice getValueIsNull();

    @Override
    public BlockEncoding getEncoding() {
        return new ArrayBlockEncoding(this.getValues().getEncoding());
    }

    private int getOffset(int position) {
        return position == 0 ? 0 : this.getOffsets().getInt((position - 1) * 4) - this.getOffsetBase();
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        SliceOutput newOffsets = Slices.allocate((int)(positions.size() * 4)).getOutput();
        SliceOutput newValueIsNull = Slices.allocate((int)positions.size()).getOutput();
        ArrayList<Integer> valuesPositions = new ArrayList<Integer>();
        int countNewOffset = 0;
        for (int position : positions) {
            if (this.isNull(position)) {
                newValueIsNull.appendByte(1);
                newOffsets.appendInt(countNewOffset);
                continue;
            }
            newValueIsNull.appendByte(0);
            int positionStartOffset = this.getOffset(position);
            int positionEndOffset = this.getOffset(position + 1);
            newOffsets.appendInt(countNewOffset += positionEndOffset - positionStartOffset);
            for (int j = positionStartOffset; j < positionEndOffset; ++j) {
                valuesPositions.add(j);
            }
        }
        Block newValues = this.getValues().copyPositions(valuesPositions);
        return new ArrayBlock(newValues, newOffsets.slice(), 0, newValueIsNull.slice());
    }

    @Override
    public Block getRegion(int position, int length) {
        return this.getRegion(position, length, false);
    }

    @Override
    public Block copyRegion(int position, int length) {
        return this.getRegion(position, length, true);
    }

    private Block getRegion(int position, int length, boolean compact) {
        int newOffsetBase;
        Slice newValueIsNull;
        Slice newOffsets;
        Block newValues;
        int positionCount = this.getPositionCount();
        if (position < 0 || length < 0 || position + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + position + " in block with " + positionCount + " positions");
        }
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + length);
        if (compact) {
            newValues = this.getValues().copyRegion(startValueOffset, endValueOffset - startValueOffset);
            int[] newOffsetsArray = new int[length];
            for (int i = 0; i < length; ++i) {
                newOffsetsArray[i] = this.getOffset(position + i + 1) - this.getOffset(position);
            }
            newOffsets = Slices.wrappedIntArray((int[])newOffsetsArray);
            newValueIsNull = Slices.copyOf((Slice)this.getValueIsNull(), (int)position, (int)length);
            newOffsetBase = 0;
        } else {
            if (position == 0 && length == positionCount) {
                return this;
            }
            newValues = this.getValues().getRegion(startValueOffset, endValueOffset - startValueOffset);
            newOffsets = this.getOffsets().slice(position * 4, length * 4);
            newValueIsNull = this.getValueIsNull().slice(position, length);
            newOffsetBase = startValueOffset + this.getOffsetBase();
        }
        return new ArrayBlock(newValues, newOffsets, newOffsetBase, newValueIsNull);
    }

    @Override
    public int getLength(int position) {
        return this.getOffset(position + 1) - this.getOffset(position);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        if (clazz != Block.class) {
            throw new IllegalArgumentException("clazz must be Block.class");
        }
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        return clazz.cast(this.getValues().getRegion(startValueOffset, endValueOffset - startValueOffset));
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        for (int i = startValueOffset; i < endValueOffset; ++i) {
            if (this.getValues().isNull(i)) {
                entryBuilder.appendNull();
                continue;
            }
            this.getValues().writePositionTo(i, entryBuilder);
            entryBuilder.closeEntry();
        }
    }

    @Override
    public byte getByte(int position, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(int position, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(int position, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong(int position, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFloat(int position, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(int position, int offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hash(int position, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int compareTo(int position, int offset, int length, Block otherBlock, int otherPosition, int otherOffset, int otherLength) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        Block newValues = this.getValues().copyRegion(startValueOffset, endValueOffset - startValueOffset);
        Slice newOffsets = Slices.wrappedIntArray((int[])new int[]{endValueOffset - startValueOffset});
        Slice newValueIsNull = Slices.copyOf((Slice)this.getValueIsNull(), (int)position, (int)1);
        return new ArrayBlock(newValues, newOffsets, 0, newValueIsNull);
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.getValueIsNull().getByte(position) != 0;
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

