/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractInterleavedBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.InterleavedBlockEncoding;
import org.openjdk.jol.info.ClassLayout;

public class InterleavedBlock
extends AbstractInterleavedBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(InterleavedBlock.class).instanceSize();
    private final Block[] blocks;
    private final InterleavedBlockEncoding blockEncoding;
    private final int positionCount;
    private final int sizeInBytes;
    private final int retainedSizeInBytes;

    public InterleavedBlock(Block[] blocks) {
        super(blocks.length);
        this.blocks = blocks;
        int sizeInBytes = 0;
        int retainedSizeInBytes = INSTANCE_SIZE;
        int positionCount = 0;
        int firstSubBlockPositionCount = blocks[0].getPositionCount();
        boolean subBlockHasDifferentSize = false;
        for (int i = 0; i < this.getBlockCount(); ++i) {
            sizeInBytes += blocks[i].getSizeInBytes();
            retainedSizeInBytes += blocks[i].getRetainedSizeInBytes();
            positionCount += blocks[i].getPositionCount();
            if (subBlockHasDifferentSize) {
                if (firstSubBlockPositionCount - 1 == blocks[i].getPositionCount()) continue;
                throw new IllegalArgumentException("length of sub blocks differ by at least 2 or is not non-ascending: block 0: " + firstSubBlockPositionCount + ", block " + i + ": " + blocks[i].getPositionCount());
            }
            if (firstSubBlockPositionCount == blocks[i].getPositionCount()) continue;
            if (firstSubBlockPositionCount - 1 == blocks[i].getPositionCount()) {
                subBlockHasDifferentSize = true;
                continue;
            }
            throw new IllegalArgumentException("length of sub blocks differ by at least 2: block 0: " + firstSubBlockPositionCount + ", block " + i + ": " + blocks[i].getPositionCount());
        }
        this.blockEncoding = this.computeBlockEncoding();
        this.positionCount = positionCount;
        this.sizeInBytes = sizeInBytes;
        this.retainedSizeInBytes = retainedSizeInBytes;
    }

    @Override
    protected Block getBlock(int blockIndex) {
        if (blockIndex < 0) {
            throw new IllegalArgumentException("position is not valid");
        }
        return this.blocks[blockIndex];
    }

    @Override
    public InterleavedBlockEncoding getEncoding() {
        return this.blockEncoding;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public int getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("InterleavedBlock{");
        sb.append("columns=").append(this.getBlockCount());
        sb.append(", positionCount=").append(this.getPositionCount() / this.getBlockCount());
        sb.append('}');
        return sb.toString();
    }
}

