/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingFactory;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.type.TypeManager;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;

public class LazyBlockEncoding
implements BlockEncoding {
    private final BlockEncoding delegate;

    public LazyBlockEncoding(BlockEncoding delegate) {
        this.delegate = delegate;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public void writeBlock(SliceOutput sliceOutput, Block block) {
        this.delegate.writeBlock(sliceOutput, ((LazyBlock)block).getBlock());
    }

    @Override
    public int getEstimatedSize(Block block) {
        return this.delegate.getEstimatedSize(((LazyBlock)block).getBlock());
    }

    @Override
    public Block readBlock(SliceInput sliceInput) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockEncodingFactory getFactory() {
        return new LazyBlockEncodingFactory(this.delegate.getFactory());
    }

    public static class LazyBlockEncodingFactory
    implements BlockEncodingFactory<LazyBlockEncoding> {
        private final BlockEncodingFactory delegate;

        public LazyBlockEncodingFactory(BlockEncodingFactory delegate) {
            this.delegate = delegate;
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public LazyBlockEncoding readEncoding(TypeManager manager, BlockEncodingSerde serde, SliceInput input) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void writeEncoding(BlockEncodingSerde serde, SliceOutput output, LazyBlockEncoding blockEncoding) {
            this.delegate.writeEncoding(serde, output, blockEncoding.delegate);
        }
    }
}

