/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spi.block;

import com.facebook.presto.spi.block.AbstractVariableWidthBlock;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockValidationUtil;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.LazyBlockLoader;
import com.facebook.presto.spi.block.LazySliceArrayBlockEncoding;
import com.facebook.presto.spi.block.SliceArrayBlock;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openjdk.jol.info.ClassLayout;

public class LazySliceArrayBlock
extends AbstractVariableWidthBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LazySliceArrayBlock.class).instanceSize();
    private final int positionCount;
    private final AtomicInteger sizeInBytes = new AtomicInteger(-1);
    private final AtomicInteger retainedSizeInBytes = new AtomicInteger(-1);
    private LazyBlockLoader<LazySliceArrayBlock> loader;
    private Slice[] values;
    private boolean dictionary;
    private int[] ids;
    private boolean[] isNull;

    public LazySliceArrayBlock(int positionCount, LazyBlockLoader<LazySliceArrayBlock> loader) {
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        this.loader = Objects.requireNonNull(loader);
    }

    @Override
    public BlockEncoding getEncoding() {
        return new LazySliceArrayBlockEncoding();
    }

    @Override
    public Block copyPositions(List<Integer> positions) {
        BlockValidationUtil.checkValidPositions(positions, this.positionCount);
        this.assureLoaded();
        if (this.dictionary) {
            return this.compactAndGet(positions, false);
        }
        Slice[] newValues = new Slice[positions.size()];
        for (int i = 0; i < positions.size(); ++i) {
            if (this.isEntryNull(positions.get(i))) continue;
            newValues[i] = Slices.copyOf((Slice)this.values[positions.get(i)]);
        }
        return new SliceArrayBlock(positions.size(), newValues);
    }

    @Override
    protected Slice getRawSlice(int position) {
        this.assureLoaded();
        return this.values[this.getPosition(position)];
    }

    @Override
    protected int getPositionOffset(int position) {
        return 0;
    }

    @Override
    protected boolean isEntryNull(int position) {
        this.assureLoaded();
        if (this.isNull != null) {
            return this.isNull[position];
        }
        return this.values[this.getPosition(position)] == null;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getLength(int position) {
        this.assureLoaded();
        return this.values[this.getPosition(position)].length();
    }

    @Override
    public int getSizeInBytes() {
        int sizeInBytes = this.sizeInBytes.get();
        if (sizeInBytes < 0) {
            this.assureLoaded();
            sizeInBytes = SliceArrayBlock.getSliceArraySizeInBytes(this.values);
            if (this.dictionary) {
                sizeInBytes += this.ids.length * 4;
                sizeInBytes += this.isNull.length * 1;
            }
            this.sizeInBytes.set(sizeInBytes);
        }
        return sizeInBytes;
    }

    @Override
    public int getRetainedSizeInBytes() {
        int sizeInBytes = this.retainedSizeInBytes.get();
        if (sizeInBytes < 0) {
            this.assureLoaded();
            sizeInBytes = INSTANCE_SIZE + SliceArrayBlock.getSliceArrayRetainedSizeInBytes(this.values);
            if (this.dictionary) {
                sizeInBytes = (int)((long)sizeInBytes + SizeOf.sizeOf((int[])this.ids));
                sizeInBytes = (int)((long)sizeInBytes + SizeOf.sizeOf((boolean[])this.isNull));
            }
            this.retainedSizeInBytes.set(sizeInBytes);
        }
        return sizeInBytes;
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        this.assureLoaded();
        if (this.dictionary) {
            List<Integer> positions = IntStream.range(positionOffset, positionOffset + length).boxed().collect(Collectors.toList());
            return this.compactAndGet(positions, false);
        }
        Slice[] newValues = Arrays.copyOfRange(this.values, positionOffset, positionOffset + length);
        return new SliceArrayBlock(length, newValues);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        int positionCount = this.getPositionCount();
        if (positionOffset < 0 || length < 0 || positionOffset + length > positionCount) {
            throw new IndexOutOfBoundsException("Invalid position " + positionOffset + " in block with " + positionCount + " positions");
        }
        this.assureLoaded();
        if (this.dictionary) {
            List<Integer> positions = IntStream.range(positionOffset, positionOffset + length).boxed().collect(Collectors.toList());
            return this.compactAndGet(positions, true);
        }
        return new SliceArrayBlock(length, SliceArrayBlock.deepCopyAndCompact(this.values, positionOffset, length));
    }

    @Override
    public void assureLoaded() {
        if (this.values != null) {
            return;
        }
        this.loader.load(this);
        if (this.values == null) {
            throw new IllegalArgumentException("Lazy block loader did not load this block");
        }
        this.loader = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LazySliceArrayBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append('}');
        return sb.toString();
    }

    private Block compactAndGet(List<Integer> positions, boolean copy) {
        int[] newIds = new int[positions.size()];
        boolean hasNull = false;
        int[] newDictionaryIndexes = new int[this.values.length];
        Arrays.fill(newDictionaryIndexes, -1);
        int nextIndex = 0;
        for (int i = 0; i < positions.size(); ++i) {
            int position = positions.get(i);
            if (this.isEntryNull(position)) {
                hasNull = true;
                newIds[i] = -1;
                continue;
            }
            int oldIndex = this.ids[position];
            if (newDictionaryIndexes[oldIndex] == -1) {
                newDictionaryIndexes[oldIndex] = nextIndex++;
            }
            newIds[i] = newDictionaryIndexes[oldIndex];
        }
        int newDictionaryLength = nextIndex;
        if (hasNull) {
            ++newDictionaryLength;
        }
        Slice[] newValues = new Slice[newDictionaryLength];
        for (int i = 0; i < this.values.length; ++i) {
            if (newDictionaryIndexes[i] == -1) continue;
            Slice value = this.values[i];
            int newIndex = newDictionaryIndexes[i];
            newValues[newIndex] = copy ? Slices.copyOf((Slice)value) : value;
        }
        if (hasNull) {
            int nullIndex = newValues.length - 1;
            for (int i = 0; i < newIds.length; ++i) {
                if (newIds[i] != -1) continue;
                newIds[i] = nullIndex;
            }
        }
        return new DictionaryBlock(positions.size(), new SliceArrayBlock(newValues.length, newValues), Slices.wrappedIntArray((int[])newIds));
    }

    private int getPosition(int position) {
        if (this.dictionary) {
            return this.ids[position];
        }
        return position;
    }

    public Slice[] getValues() {
        this.assureLoaded();
        return this.values;
    }

    public int[] getIds() {
        return this.ids;
    }

    public DictionaryBlock createDictionaryBlock() {
        if (!this.dictionary) {
            throw new IllegalStateException("cannot create dictionary block");
        }
        if (this.isNull == null) {
            return new DictionaryBlock(this.getPositionCount(), new SliceArrayBlock(this.values.length, this.values), Slices.wrappedIntArray((int[])this.ids));
        }
        boolean hasNulls = false;
        int[] newIds = Arrays.copyOf(this.ids, this.ids.length);
        for (int position = 0; position < this.positionCount; ++position) {
            if (!this.isEntryNull(position)) continue;
            hasNulls = true;
            newIds[position] = this.values.length;
        }
        Slice[] newValues = hasNulls ? Arrays.copyOf(this.values, this.values.length + 1) : this.values;
        return new DictionaryBlock(this.getPositionCount(), new SliceArrayBlock(newValues.length, newValues), Slices.wrappedIntArray((int[])newIds));
    }

    public boolean isDictionary() {
        this.assureLoaded();
        return this.dictionary;
    }

    public void setValues(Slice[] values) {
        Objects.requireNonNull(values, "values is null");
        this.values = values;
    }

    public void setValues(Slice[] values, int[] ids, boolean[] isNull) {
        Objects.requireNonNull(values, "values is null");
        Objects.requireNonNull(ids, "ids is null");
        Objects.requireNonNull(isNull, "isNull is null");
        if (ids.length != this.positionCount) {
            throw new IllegalArgumentException(String.format("ids length %s is not equal to positionCount %s", ids.length, this.positionCount));
        }
        if (ids.length != isNull.length) {
            throw new IllegalArgumentException("ids length does not match isNull length");
        }
        this.setValues(values);
        this.ids = ids;
        this.isNull = isNull;
        this.dictionary = true;
    }

    public Block createNonLazyBlock() {
        this.assureLoaded();
        if (!this.dictionary) {
            return new SliceArrayBlock(this.getPositionCount(), this.values);
        }
        return this.createDictionaryBlock();
    }
}

