/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.DiskRange;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public final class OrcDataSourceUtils {
    private OrcDataSourceUtils() {
    }

    public static List<DiskRange> mergeAdjacentDiskRanges(Iterable<DiskRange> diskRanges, DataSize maxMergeDistance, DataSize maxReadSize) {
        ArrayList ranges = Lists.newArrayList(diskRanges);
        Collections.sort(ranges, new Comparator<DiskRange>(){

            @Override
            public int compare(DiskRange o1, DiskRange o2) {
                return Long.compare(o1.getOffset(), o2.getOffset());
            }
        });
        long maxReadSizeBytes = maxReadSize.toBytes();
        long maxMergeDistanceBytes = maxMergeDistance.toBytes();
        ImmutableList.Builder result = ImmutableList.builder();
        DiskRange last = (DiskRange)ranges.get(0);
        for (int i = 1; i < ranges.size(); ++i) {
            DiskRange current = (DiskRange)ranges.get(i);
            DiskRange merged = last.span(current);
            if ((long)merged.getLength() <= maxReadSizeBytes && last.getEnd() + maxMergeDistanceBytes >= current.getOffset()) {
                last = merged;
                continue;
            }
            result.add((Object)last);
            last = current;
        }
        result.add((Object)last);
        return result.build();
    }

    public static Slice getDiskRangeSlice(DiskRange diskRange, Map<DiskRange, byte[]> buffers) {
        for (Map.Entry<DiskRange, byte[]> bufferEntry : buffers.entrySet()) {
            DiskRange bufferRange = bufferEntry.getKey();
            byte[] buffer = bufferEntry.getValue();
            if (!bufferRange.contains(diskRange)) continue;
            int offset = Ints.checkedCast((long)(diskRange.getOffset() - bufferRange.getOffset()));
            return Slices.wrappedBuffer((byte[])buffer, (int)offset, (int)diskRange.getLength());
        }
        throw new IllegalStateException("No matching buffer for disk range");
    }
}

