/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.metadata.Stream;
import com.google.common.base.MoreObjects;

public final class StreamId {
    private final int column;
    private final Stream.StreamKind streamKind;

    public StreamId(Stream stream) {
        this.column = stream.getColumn();
        this.streamKind = stream.getStreamKind();
    }

    public StreamId(int column, Stream.StreamKind streamKind) {
        this.column = column;
        this.streamKind = streamKind;
    }

    public int getColumn() {
        return this.column;
    }

    public Stream.StreamKind getStreamKind() {
        return this.streamKind;
    }

    public int hashCode() {
        return 31 * this.column + this.streamKind.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StreamId other = (StreamId)obj;
        return this.column == other.column && this.streamKind == other.streamKind;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("column", this.column).add("streamKind", (Object)this.streamKind).toString();
    }
}

