/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.RowGroup;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.stream.StreamSources;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class Stripe {
    private final long rowCount;
    private final List<ColumnEncoding> columnEncodings;
    private final List<RowGroup> rowGroups;
    private final StreamSources dictionaryStreamSources;

    public Stripe(long rowCount, List<ColumnEncoding> columnEncodings, List<RowGroup> rowGroups, StreamSources dictionaryStreamSources) {
        this.rowCount = rowCount;
        this.columnEncodings = Objects.requireNonNull(columnEncodings, "columnEncodings is null");
        this.rowGroups = ImmutableList.copyOf((Collection)Objects.requireNonNull(rowGroups, "rowGroups is null"));
        this.dictionaryStreamSources = Objects.requireNonNull(dictionaryStreamSources, "dictionaryStreamSources is null");
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public List<ColumnEncoding> getColumnEncodings() {
        return this.columnEncodings;
    }

    public List<RowGroup> getRowGroups() {
        return this.rowGroups;
    }

    public StreamSources getDictionaryStreamSources() {
        return this.dictionaryStreamSources;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rowCount", this.rowCount).add("columnEncodings", this.columnEncodings).add("rowGroups", this.rowGroups).add("dictionaryStreams", (Object)this.dictionaryStreamSources).toString();
    }
}

