/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.facebook.presto.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import com.facebook.presto.hadoop.$internal.com.google.common.collect.ComparisonChain;
import com.facebook.presto.hadoop.$internal.com.google.common.collect.Lists;
import com.facebook.presto.hadoop.$internal.com.google.common.collect.Maps;
import com.facebook.presto.hadoop.$internal.com.google.common.util.concurrent.Futures;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.HardLink;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.LayoutVersion;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.common.InconsistentFSStateException;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.datanode.BlockPoolSliceStorage;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeLayoutVersion;
import org.apache.hadoop.hdfs.server.datanode.DatanodeUtil;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorage;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.DiskChecker;

@InterfaceAudience.Private
public class DataStorage
extends Storage {
    public static final String BLOCK_SUBDIR_PREFIX = "subdir";
    static final String COPY_FILE_PREFIX = "dncp_";
    static final String STORAGE_DIR_DETACHED = "detach";
    public static final String STORAGE_DIR_RBW = "rbw";
    public static final String STORAGE_DIR_FINALIZED = "finalized";
    public static final String STORAGE_DIR_LAZY_PERSIST = "lazypersist";
    public static final String STORAGE_DIR_TMP = "tmp";
    private Set<String> trashEnabledBpids;
    private String datanodeUuid = null;
    private boolean initialized = false;
    private final Map<String, BlockPoolSliceStorage> bpStorageMap = Collections.synchronizedMap(new HashMap());

    DataStorage() {
        super(HdfsServerConstants.NodeType.DATA_NODE);
        this.trashEnabledBpids = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    public BlockPoolSliceStorage getBPStorage(String bpid) {
        return this.bpStorageMap.get(bpid);
    }

    public DataStorage(StorageInfo storageInfo) {
        super(storageInfo);
    }

    public synchronized String getDatanodeUuid() {
        return this.datanodeUuid;
    }

    public synchronized void setDatanodeUuid(String newDatanodeUuid) {
        this.datanodeUuid = newDatanodeUuid;
    }

    public synchronized boolean createStorageID(Storage.StorageDirectory sd, boolean regenerateStorageIds) {
        String oldStorageID = sd.getStorageUuid();
        if (oldStorageID == null || regenerateStorageIds) {
            sd.setStorageUuid(DatanodeStorage.generateUuid());
            LOG.info("Generated new storageID " + sd.getStorageUuid() + " for directory " + sd.getRoot() + (oldStorageID == null ? "" : " to replace " + oldStorageID));
            return true;
        }
        return false;
    }

    public void enableTrash(String bpid) {
        if (this.trashEnabledBpids.add(bpid)) {
            LOG.info("Enabled trash for bpid " + bpid);
        }
    }

    public void restoreTrash(String bpid) {
        if (this.trashEnabledBpids.contains(bpid)) {
            this.getBPStorage(bpid).restoreTrash();
            this.trashEnabledBpids.remove(bpid);
            LOG.info("Restored trash for bpid " + bpid);
        }
    }

    public boolean trashEnabled(String bpid) {
        return this.trashEnabledBpids.contains(bpid);
    }

    public void setRollingUpgradeMarker(String bpid) throws IOException {
        this.getBPStorage(bpid).setRollingUpgradeMarkers(this.storageDirs);
    }

    public void clearRollingUpgradeMarker(String bpid) throws IOException {
        this.getBPStorage(bpid).clearRollingUpgradeMarkers(this.storageDirs);
    }

    public String getTrashDirectoryForBlockFile(String bpid, File blockFile) {
        if (this.trashEnabledBpids.contains(bpid)) {
            return this.getBPStorage(bpid).getTrashDirectory(blockFile);
        }
        return null;
    }

    private Storage.StorageDirectory loadStorageDirectory(DataNode datanode, NamespaceInfo nsInfo, File dataDir, HdfsServerConstants.StartupOption startOpt) throws IOException {
        Storage.StorageDirectory sd = new Storage.StorageDirectory(dataDir, null, false);
        try {
            Storage.StorageState curState = sd.analyzeStorage(startOpt, this);
            switch (curState) {
                case NORMAL: {
                    break;
                }
                case NON_EXISTENT: {
                    LOG.info("Storage directory " + dataDir + " does not exist");
                    throw new IOException("Storage directory " + dataDir + " does not exist");
                }
                case NOT_FORMATTED: {
                    LOG.info("Storage directory " + dataDir + " is not formatted for " + nsInfo.getBlockPoolID());
                    LOG.info("Formatting ...");
                    this.format(sd, nsInfo, datanode.getDatanodeUuid());
                    break;
                }
                default: {
                    sd.doRecover(curState);
                }
            }
            this.doTransition(datanode, sd, nsInfo, startOpt);
            this.setServiceLayoutVersion(this.getServiceLayoutVersion());
            this.writeProperties(sd);
            return sd;
        }
        catch (IOException ioe) {
            sd.unlock();
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VolumeBuilder prepareVolume(DataNode datanode, File volume, List<NamespaceInfo> nsInfos) throws IOException {
        if (this.containsStorageDir(volume)) {
            String errorMessage = "Storage directory is in use";
            LOG.warn("Storage directory is in use.");
            throw new IOException("Storage directory is in use");
        }
        Storage.StorageDirectory sd = this.loadStorageDirectory(datanode, nsInfos.get(0), volume, HdfsServerConstants.StartupOption.HOTSWAP);
        VolumeBuilder builder = new VolumeBuilder(this, sd);
        for (NamespaceInfo nsInfo : nsInfos) {
            BlockPoolSliceStorage bpStorage;
            ArrayList<File> bpDataDirs = Lists.newArrayList();
            bpDataDirs.add(BlockPoolSliceStorage.getBpRoot(nsInfo.getBlockPoolID(), new File(volume, "current")));
            DataStorage.makeBlockPoolDataDir(bpDataDirs, null);
            String bpid = nsInfo.getBlockPoolID();
            DataStorage dataStorage = this;
            synchronized (dataStorage) {
                bpStorage = this.bpStorageMap.get(bpid);
                if (bpStorage == null) {
                    bpStorage = new BlockPoolSliceStorage(nsInfo.getNamespaceID(), bpid, nsInfo.getCTime(), nsInfo.getClusterID());
                    this.addBlockPoolStorage(bpid, bpStorage);
                }
            }
            builder.addBpStorageDirectories(bpid, bpStorage.loadBpStorageDirectories(datanode, nsInfo, bpDataDirs, HdfsServerConstants.StartupOption.HOTSWAP));
        }
        return builder;
    }

    @VisibleForTesting
    synchronized List<StorageLocation> addStorageLocations(DataNode datanode, NamespaceInfo nsInfo, Collection<StorageLocation> dataDirs, HdfsServerConstants.StartupOption startOpt) throws IOException {
        String bpid = nsInfo.getBlockPoolID();
        ArrayList<StorageLocation> successVolumes = Lists.newArrayList();
        for (StorageLocation dataDir : dataDirs) {
            File root;
            block7: {
                root = dataDir.getFile();
                if (!this.containsStorageDir(root)) {
                    try {
                        Storage.StorageDirectory sd = this.loadStorageDirectory(datanode, nsInfo, root, startOpt);
                        this.addStorageDir(sd);
                        break block7;
                    }
                    catch (IOException e) {
                        LOG.warn(e);
                        continue;
                    }
                }
                LOG.info("Storage directory " + dataDir + " has already been used.");
            }
            ArrayList<File> bpDataDirs = new ArrayList<File>();
            bpDataDirs.add(BlockPoolSliceStorage.getBpRoot(bpid, new File(root, "current")));
            try {
                DataStorage.makeBlockPoolDataDir(bpDataDirs, null);
                BlockPoolSliceStorage bpStorage = this.bpStorageMap.get(bpid);
                if (bpStorage == null) {
                    bpStorage = new BlockPoolSliceStorage(nsInfo.getNamespaceID(), bpid, nsInfo.getCTime(), nsInfo.getClusterID());
                }
                bpStorage.recoverTransitionRead(datanode, nsInfo, bpDataDirs, startOpt);
                this.addBlockPoolStorage(bpid, bpStorage);
            }
            catch (IOException e) {
                LOG.warn("Failed to add storage for block pool: " + bpid + " : " + e.getMessage());
                continue;
            }
            successVolumes.add(dataDir);
        }
        return successVolumes;
    }

    synchronized void removeVolumes(Set<File> dirsToRemove) throws IOException {
        if (dirsToRemove.isEmpty()) {
            return;
        }
        StringBuilder errorMsgBuilder = new StringBuilder();
        Iterator it = this.storageDirs.iterator();
        while (it.hasNext()) {
            Storage.StorageDirectory sd = (Storage.StorageDirectory)it.next();
            if (!dirsToRemove.contains(sd.getRoot())) continue;
            for (Map.Entry<String, BlockPoolSliceStorage> entry : this.bpStorageMap.entrySet()) {
                String bpid = entry.getKey();
                BlockPoolSliceStorage bpsStorage = entry.getValue();
                File bpRoot = BlockPoolSliceStorage.getBpRoot(bpid, sd.getCurrentDir());
                bpsStorage.remove(bpRoot.getAbsoluteFile());
            }
            it.remove();
            try {
                sd.unlock();
            }
            catch (IOException e) {
                LOG.warn(String.format("I/O error attempting to unlock storage directory %s.", sd.getRoot()), e);
                errorMsgBuilder.append(String.format("Failed to remove %s: %s%n", sd.getRoot(), e.getMessage()));
            }
        }
        if (errorMsgBuilder.length() > 0) {
            throw new IOException(errorMsgBuilder.toString());
        }
    }

    void recoverTransitionRead(DataNode datanode, NamespaceInfo nsInfo, Collection<StorageLocation> dataDirs, HdfsServerConstants.StartupOption startOpt) throws IOException {
        if (this.initialized) {
            LOG.info("DataNode version: " + HdfsConstants.DATANODE_LAYOUT_VERSION + " and NameNode layout version: " + nsInfo.getLayoutVersion());
            this.storageDirs = new ArrayList(dataDirs.size());
            this.initialized = true;
        }
        if (this.addStorageLocations(datanode, nsInfo, dataDirs, startOpt).isEmpty()) {
            throw new IOException("All specified directories are failed to load.");
        }
    }

    static void makeBlockPoolDataDir(Collection<File> dataDirs, Configuration conf) throws IOException {
        if (conf == null) {
            conf = new HdfsConfiguration();
        }
        LocalFileSystem localFS = FileSystem.getLocal(conf);
        FsPermission permission = new FsPermission(conf.get("dfs.datanode.data.dir.perm", "700"));
        for (File data : dataDirs) {
            try {
                DiskChecker.checkDir(localFS, new Path(data.toURI()), permission);
            }
            catch (IOException e) {
                LOG.warn("Invalid directory in: " + data.getCanonicalPath() + ": " + e.getMessage());
            }
        }
    }

    void format(Storage.StorageDirectory sd, NamespaceInfo nsInfo, String datanodeUuid) throws IOException {
        sd.clearDirectory();
        this.layoutVersion = HdfsConstants.DATANODE_LAYOUT_VERSION;
        this.clusterID = nsInfo.getClusterID();
        this.namespaceID = nsInfo.getNamespaceID();
        this.cTime = 0L;
        this.setDatanodeUuid(datanodeUuid);
        if (sd.getStorageUuid() == null) {
            sd.setStorageUuid(DatanodeStorage.generateUuid());
        }
        this.writeProperties(sd);
    }

    @Override
    protected void setPropertiesFromFields(Properties props, Storage.StorageDirectory sd) throws IOException {
        props.setProperty("storageType", this.storageType.toString());
        props.setProperty("clusterID", this.clusterID);
        props.setProperty("cTime", String.valueOf(this.cTime));
        props.setProperty("layoutVersion", String.valueOf(this.layoutVersion));
        props.setProperty("storageID", sd.getStorageUuid());
        String datanodeUuid = this.getDatanodeUuid();
        if (datanodeUuid != null) {
            props.setProperty("datanodeUuid", datanodeUuid);
        }
        if (!DataNodeLayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.layoutVersion)) {
            props.setProperty("namespaceID", String.valueOf(this.namespaceID));
        }
    }

    @Override
    protected void setFieldsFromProperties(Properties props, Storage.StorageDirectory sd) throws IOException {
        this.setFieldsFromProperties(props, sd, false, 0);
    }

    private void setFieldsFromProperties(Properties props, Storage.StorageDirectory sd, boolean overrideLayoutVersion, int toLayoutVersion) throws IOException {
        String ssid;
        if (overrideLayoutVersion) {
            this.layoutVersion = toLayoutVersion;
        } else {
            this.setLayoutVersion(props, sd);
        }
        this.setcTime(props, sd);
        this.checkStorageType(props, sd);
        this.setClusterId(props, this.layoutVersion, sd);
        if (!DataNodeLayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.layoutVersion)) {
            this.setNamespaceID(props, sd);
        }
        if ((ssid = props.getProperty("storageID")) == null) {
            throw new InconsistentFSStateException(sd.getRoot(), "file VERSION is invalid.");
        }
        String sid = sd.getStorageUuid();
        if (!(sid == null || sid.equals("") || ssid.equals("") || sid.equals(ssid))) {
            throw new InconsistentFSStateException(sd.getRoot(), "has incompatible storage Id.");
        }
        if (sid == null) {
            sd.setStorageUuid(ssid);
        }
        if (props.getProperty("datanodeUuid") != null) {
            String dnUuid = props.getProperty("datanodeUuid");
            if (this.getDatanodeUuid() == null) {
                this.setDatanodeUuid(dnUuid);
            } else if (this.getDatanodeUuid().compareTo(dnUuid) != 0) {
                throw new InconsistentFSStateException(sd.getRoot(), "Root " + sd.getRoot() + ": DatanodeUuid=" + dnUuid + ", does not match " + this.getDatanodeUuid() + " from other" + " StorageDirectory.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPreUpgradableLayout(Storage.StorageDirectory sd) throws IOException {
        File oldF = new File(sd.getRoot(), "storage");
        if (!oldF.exists()) {
            return false;
        }
        RandomAccessFile oldFile = new RandomAccessFile(oldF, "rws");
        FileLock oldLock = oldFile.getChannel().tryLock();
        try {
            oldFile.seek(0L);
            int oldVersion = oldFile.readInt();
            if (oldVersion < -3) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            oldLock.release();
            oldFile.close();
        }
        return true;
    }

    void readProperties(Storage.StorageDirectory sd, int rollbackLayoutVersion) throws IOException {
        Properties props = DataStorage.readPropertiesFile(sd.getVersionFile());
        this.setFieldsFromProperties(props, sd, true, rollbackLayoutVersion);
    }

    private void doTransition(DataNode datanode, Storage.StorageDirectory sd, NamespaceInfo nsInfo, HdfsServerConstants.StartupOption startOpt) throws IOException {
        boolean haveValidStorageId;
        if (startOpt == HdfsServerConstants.StartupOption.ROLLBACK) {
            this.doRollback(sd, nsInfo);
        }
        this.readProperties(sd);
        DataStorage.checkVersionUpgradable(this.layoutVersion);
        assert (this.layoutVersion >= HdfsConstants.DATANODE_LAYOUT_VERSION) : "Future version is not allowed";
        boolean federationSupported = DataNodeLayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.layoutVersion);
        if (!federationSupported && this.getNamespaceID() != nsInfo.getNamespaceID()) {
            throw new IOException("Incompatible namespaceIDs in " + sd.getRoot().getCanonicalPath() + ": namenode namespaceID = " + nsInfo.getNamespaceID() + "; datanode namespaceID = " + this.getNamespaceID());
        }
        if (federationSupported && !this.getClusterID().equals(nsInfo.getClusterID())) {
            throw new IOException("Incompatible clusterIDs in " + sd.getRoot().getCanonicalPath() + ": namenode clusterID = " + nsInfo.getClusterID() + "; datanode clusterID = " + this.getClusterID());
        }
        boolean bl = haveValidStorageId = DataNodeLayoutVersion.supports(LayoutVersion.Feature.ADD_DATANODE_AND_STORAGE_UUIDS, this.layoutVersion) && DatanodeStorage.isValidStorageId(sd.getStorageUuid());
        if (this.layoutVersion == HdfsConstants.DATANODE_LAYOUT_VERSION) {
            this.createStorageID(sd, !haveValidStorageId);
            return;
        }
        if (this.layoutVersion > HdfsConstants.DATANODE_LAYOUT_VERSION) {
            this.doUpgrade(datanode, sd, nsInfo);
            this.createStorageID(sd, !haveValidStorageId);
            return;
        }
        throw new IOException("BUG: The stored LV = " + this.getLayoutVersion() + " is newer than the supported LV = " + HdfsConstants.DATANODE_LAYOUT_VERSION);
    }

    void doUpgrade(DataNode datanode, Storage.StorageDirectory sd, NamespaceInfo nsInfo) throws IOException {
        if (DataNodeLayoutVersion.supports(LayoutVersion.Feature.FEDERATION, this.layoutVersion)) {
            LOG.info("Updating layout version from " + this.layoutVersion + " to " + HdfsConstants.DATANODE_LAYOUT_VERSION + " for storage " + sd.getRoot());
            this.layoutVersion = HdfsConstants.DATANODE_LAYOUT_VERSION;
            this.writeProperties(sd);
            return;
        }
        LOG.info("Upgrading storage directory " + sd.getRoot() + ".\n   old LV = " + this.getLayoutVersion() + "; old CTime = " + this.getCTime() + ".\n   new LV = " + HdfsConstants.DATANODE_LAYOUT_VERSION + "; new CTime = " + nsInfo.getCTime());
        File curDir = sd.getCurrentDir();
        File prevDir = sd.getPreviousDir();
        File bbwDir = new File(sd.getRoot(), "blocksBeingWritten");
        assert (curDir.exists()) : "Data node current directory must exist.";
        this.cleanupDetachDir(new File(curDir, STORAGE_DIR_DETACHED));
        if (prevDir.exists()) {
            DataStorage.deleteDir(prevDir);
        }
        File tmpDir = sd.getPreviousTmp();
        assert (!tmpDir.exists()) : "Data node previous.tmp directory must not exist.";
        DataStorage.rename(curDir, tmpDir);
        File curBpDir = BlockPoolSliceStorage.getBpRoot(nsInfo.getBlockPoolID(), curDir);
        BlockPoolSliceStorage bpStorage = new BlockPoolSliceStorage(nsInfo.getNamespaceID(), nsInfo.getBlockPoolID(), nsInfo.getCTime(), nsInfo.getClusterID());
        bpStorage.format(curDir, nsInfo);
        this.linkAllBlocks(datanode, tmpDir, bbwDir, new File(curBpDir, "current"));
        this.layoutVersion = HdfsConstants.DATANODE_LAYOUT_VERSION;
        this.clusterID = nsInfo.getClusterID();
        this.writeProperties(sd);
        DataStorage.rename(tmpDir, prevDir);
        LOG.info("Upgrade of " + sd.getRoot() + " is complete");
        this.addBlockPoolStorage(nsInfo.getBlockPoolID(), bpStorage);
    }

    private void cleanupDetachDir(File detachDir) throws IOException {
        if (!DataNodeLayoutVersion.supports(LayoutVersion.Feature.APPEND_RBW_DIR, this.layoutVersion) && detachDir.exists() && detachDir.isDirectory()) {
            if (FileUtil.list(detachDir).length != 0) {
                throw new IOException("Detached directory " + detachDir + " is not empty. Please manually move each file under this " + "directory to the finalized directory if the finalized " + "directory tree does not have the file.");
            }
            if (!detachDir.delete()) {
                throw new IOException("Cannot remove directory " + detachDir);
            }
        }
    }

    void doRollback(Storage.StorageDirectory sd, NamespaceInfo nsInfo) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            if (DataNodeLayoutVersion.supports(LayoutVersion.Feature.FEDERATION, HdfsConstants.DATANODE_LAYOUT_VERSION)) {
                this.readProperties(sd, HdfsConstants.DATANODE_LAYOUT_VERSION);
                this.writeProperties(sd);
                LOG.info("Layout version rolled back to " + HdfsConstants.DATANODE_LAYOUT_VERSION + " for storage " + sd.getRoot());
            }
            return;
        }
        DataStorage prevInfo = new DataStorage();
        prevInfo.readPreviousVersionProperties(sd);
        if (prevInfo.getLayoutVersion() < HdfsConstants.DATANODE_LAYOUT_VERSION || prevInfo.getCTime() > nsInfo.getCTime()) {
            throw new InconsistentFSStateException(sd.getRoot(), "Cannot rollback to a newer state.\nDatanode previous state: LV = " + prevInfo.getLayoutVersion() + " CTime = " + prevInfo.getCTime() + " is newer than the namespace state: LV = " + HdfsConstants.DATANODE_LAYOUT_VERSION + " CTime = " + nsInfo.getCTime());
        }
        LOG.info("Rolling back storage directory " + sd.getRoot() + ".\n   target LV = " + HdfsConstants.DATANODE_LAYOUT_VERSION + "; target CTime = " + nsInfo.getCTime());
        File tmpDir = sd.getRemovedTmp();
        assert (!tmpDir.exists()) : "removed.tmp directory must not exist.";
        File curDir = sd.getCurrentDir();
        assert (curDir.exists()) : "Current directory must exist.";
        DataStorage.rename(curDir, tmpDir);
        DataStorage.rename(prevDir, curDir);
        DataStorage.deleteDir(tmpDir);
        LOG.info("Rollback of " + sd.getRoot() + " is complete");
    }

    void doFinalize(Storage.StorageDirectory sd) throws IOException {
        File prevDir = sd.getPreviousDir();
        if (!prevDir.exists()) {
            return;
        }
        final String dataDirPath = sd.getRoot().getCanonicalPath();
        LOG.info("Finalizing upgrade for storage directory " + dataDirPath + ".\n   cur LV = " + this.getLayoutVersion() + "; cur CTime = " + this.getCTime());
        assert (sd.getCurrentDir().exists()) : "Current directory must exist.";
        final File tmpDir = sd.getFinalizedTmp();
        final File bbwDir = new File(sd.getRoot(), "blocksBeingWritten");
        DataStorage.rename(prevDir, tmpDir);
        new Daemon(new Runnable(){

            @Override
            public void run() {
                try {
                    Storage.deleteDir(tmpDir);
                    if (bbwDir.exists()) {
                        Storage.deleteDir(bbwDir);
                    }
                }
                catch (IOException ex) {
                    Storage.LOG.error("Finalize upgrade for " + dataDirPath + " failed", ex);
                }
                Storage.LOG.info("Finalize upgrade for " + dataDirPath + " is complete");
            }

            public String toString() {
                return "Finalize " + dataDirPath;
            }
        }).start();
    }

    void finalizeUpgrade(String bpID) throws IOException {
        for (Storage.StorageDirectory sd : this.storageDirs) {
            File prevDir = sd.getPreviousDir();
            if (prevDir.exists()) {
                this.doFinalize(sd);
                continue;
            }
            BlockPoolSliceStorage bpStorage = this.bpStorageMap.get(bpID);
            bpStorage.doFinalize(sd.getCurrentDir());
        }
    }

    private void linkAllBlocks(DataNode datanode, File fromDir, File fromBbwDir, File toDir) throws IOException {
        HardLink hardLink = new HardLink();
        int diskLayoutVersion = this.getLayoutVersion();
        if (DataNodeLayoutVersion.supports(LayoutVersion.Feature.APPEND_RBW_DIR, diskLayoutVersion)) {
            DataStorage.linkBlocks(datanode, new File(fromDir, STORAGE_DIR_FINALIZED), new File(toDir, STORAGE_DIR_FINALIZED), diskLayoutVersion, hardLink);
            DataStorage.linkBlocks(datanode, new File(fromDir, STORAGE_DIR_RBW), new File(toDir, STORAGE_DIR_RBW), diskLayoutVersion, hardLink);
        } else {
            DataStorage.linkBlocks(datanode, fromDir, new File(toDir, STORAGE_DIR_FINALIZED), diskLayoutVersion, hardLink);
            if (fromBbwDir.exists()) {
                DataStorage.linkBlocks(datanode, fromBbwDir, new File(toDir, STORAGE_DIR_RBW), diskLayoutVersion, hardLink);
            }
        }
        LOG.info(hardLink.linkStats.report());
    }

    static void linkBlocks(DataNode datanode, File from, File to, int oldLV, HardLink hl) throws IOException {
        boolean upgradeToIdBasedLayout = false;
        if (oldLV > DataNodeLayoutVersion.Feature.BLOCKID_BASED_LAYOUT.getInfo().getLayoutVersion() && to.getName().equals(STORAGE_DIR_FINALIZED)) {
            upgradeToIdBasedLayout = true;
        }
        final ArrayList<LinkArgs> idBasedLayoutSingleLinks = Lists.newArrayList();
        DataStorage.linkBlocksHelper(from, to, oldLV, hl, upgradeToIdBasedLayout, to, idBasedLayoutSingleLinks);
        ArrayList<LinkArgs> duplicates = DataStorage.findDuplicateEntries(idBasedLayoutSingleLinks);
        if (!duplicates.isEmpty()) {
            LOG.error("There are " + duplicates.size() + " duplicate block " + "entries within the same volume.");
            DataStorage.removeDuplicateEntries(idBasedLayoutSingleLinks, duplicates);
        }
        int numLinkWorkers = datanode.getConf().getInt("dfs.datanode.block.id.layout.upgrade.threads", 12);
        ExecutorService linkWorkers = Executors.newFixedThreadPool(numLinkWorkers);
        final int step = idBasedLayoutSingleLinks.size() / numLinkWorkers + 1;
        ArrayList<Future<Void>> futures = Lists.newArrayList();
        for (int i = 0; i < idBasedLayoutSingleLinks.size(); i += step) {
            final int n = i;
            futures.add(linkWorkers.submit(new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    int upperBound = Math.min(n + step, idBasedLayoutSingleLinks.size());
                    for (int j = n; j < upperBound; ++j) {
                        LinkArgs cur = (LinkArgs)idBasedLayoutSingleLinks.get(j);
                        NativeIO.link(cur.src, cur.dst);
                    }
                    return null;
                }
            }));
        }
        linkWorkers.shutdown();
        for (Future future : futures) {
            Futures.get(future, IOException.class);
        }
    }

    static ArrayList<LinkArgs> findDuplicateEntries(ArrayList<LinkArgs> all) {
        Collections.sort(all, new Comparator<LinkArgs>(){

            @Override
            public int compare(LinkArgs a, LinkArgs b) {
                return ComparisonChain.start().compare((Comparable<?>)((Object)a.src.getName()), (Comparable<?>)((Object)b.src.getName())).compare(a.src, b.src).compare(a.dst, b.dst).result();
            }
        });
        ArrayList<LinkArgs> duplicates = Lists.newArrayList();
        Long prevBlockId = null;
        boolean prevWasMeta = false;
        boolean addedPrev = false;
        for (int i = 0; i < all.size(); ++i) {
            LinkArgs args = all.get(i);
            long blockId = Block.getBlockId(args.src.getName());
            boolean isMeta = Block.isMetaFilename(args.src.getName());
            if (prevBlockId == null || prevBlockId != blockId) {
                prevBlockId = blockId;
                addedPrev = false;
            } else if (isMeta == prevWasMeta) {
                duplicates.add(args);
                if (!addedPrev) {
                    duplicates.add(all.get(i - 1));
                }
                addedPrev = true;
            } else {
                addedPrev = false;
            }
            prevWasMeta = isMeta;
        }
        return duplicates;
    }

    private static void removeDuplicateEntries(ArrayList<LinkArgs> all, ArrayList<LinkArgs> duplicates) {
        long blockId;
        TreeMap highestGenstamps = new TreeMap();
        for (LinkArgs linkArgs : duplicates) {
            if (!Block.isMetaFilename(linkArgs.src.getName())) continue;
            long blockId2 = Block.getBlockId(linkArgs.src.getName());
            List prevHighest = (List)highestGenstamps.get(blockId2);
            if (prevHighest == null) {
                LinkedList<LinkArgs> highest = new LinkedList<LinkArgs>();
                highest.add(linkArgs);
                highestGenstamps.put(blockId2, highest);
                continue;
            }
            long prevGenstamp = Block.getGenerationStamp(((LinkArgs)prevHighest.get((int)0)).src.getName());
            long genstamp = Block.getGenerationStamp(linkArgs.src.getName());
            if (genstamp < prevGenstamp) continue;
            if (genstamp > prevGenstamp) {
                prevHighest.clear();
            }
            prevHighest.add(linkArgs);
        }
        Iterator<LinkArgs> iter = duplicates.iterator();
        while (iter.hasNext()) {
            LinkArgs linkArgs = iter.next();
            long blockId2 = Block.getBlockId(linkArgs.src.getName());
            List highest = (List)highestGenstamps.get(blockId2);
            if (highest == null) continue;
            boolean found = false;
            for (LinkArgs high : highest) {
                if (!high.src.getParent().equals(linkArgs.src.getParent())) continue;
                found = true;
                break;
            }
            if (found) continue;
            LOG.warn("Unexpectedly low genstamp on " + linkArgs.src.getAbsolutePath() + ".");
            iter.remove();
        }
        TreeMap<Long, LinkArgs> longestBlockFiles = new TreeMap<Long, LinkArgs>();
        for (LinkArgs duplicate : duplicates) {
            long prevBlockLength;
            if (Block.isMetaFilename(duplicate.src.getName())) continue;
            blockId = Block.getBlockId(duplicate.src.getName());
            LinkArgs prevLongest = (LinkArgs)longestBlockFiles.get(blockId);
            if (prevLongest == null) {
                longestBlockFiles.put(blockId, duplicate);
                continue;
            }
            long blockLength = duplicate.src.length();
            if (blockLength < (prevBlockLength = prevLongest.src.length())) {
                LOG.warn("Unexpectedly short length on " + duplicate.src.getAbsolutePath() + ".");
                continue;
            }
            if (blockLength > prevBlockLength) {
                LOG.warn("Unexpectedly short length on " + prevLongest.src.getAbsolutePath() + ".");
            }
            longestBlockFiles.put(blockId, duplicate);
        }
        Iterator<LinkArgs> iterator = all.iterator();
        while (iterator.hasNext()) {
            LinkArgs args = iterator.next();
            blockId = Block.getBlockId(args.src.getName());
            LinkArgs bestDuplicate = (LinkArgs)longestBlockFiles.get(blockId);
            if (bestDuplicate == null || bestDuplicate.src.getParent().equals(args.src.getParent())) continue;
            LOG.warn("Discarding " + args.src.getAbsolutePath() + ".");
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void linkBlocksHelper(File from, File to, int oldLV, HardLink hl, boolean upgradeToIdBasedLayout, File blockRoot, List<LinkArgs> idBasedLayoutSingleLinks) throws IOException {
        if (!from.exists()) {
            return;
        }
        if (!from.isDirectory()) {
            block17: {
                if (from.getName().startsWith(COPY_FILE_PREFIX)) {
                    try (FileInputStream in = new FileInputStream(from);
                         FileOutputStream out = new FileOutputStream(to);){
                        IOUtils.copyBytes((InputStream)in, (OutputStream)out, 16384);
                        ++hl.linkStats.countPhysicalFileCopies;
                        break block17;
                    }
                }
                HardLink.createHardLink(from, to);
                ++hl.linkStats.countSingleLinks;
            }
            return;
        }
        ++hl.linkStats.countDirs;
        String[] blockNames = from.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("blk_");
            }
        });
        if (!(upgradeToIdBasedLayout && to.getName().startsWith(BLOCK_SUBDIR_PREFIX) || to.mkdirs())) {
            throw new IOException("Cannot create directory " + to);
        }
        if (blockNames.length > 0) {
            if (upgradeToIdBasedLayout) {
                for (String blockName : blockNames) {
                    long blockId = Block.getBlockId(blockName);
                    File blockLocation = DatanodeUtil.idToBlockDir(blockRoot, blockId);
                    if (!blockLocation.exists() && !blockLocation.mkdirs()) {
                        throw new IOException("Failed to mkdirs " + blockLocation);
                    }
                    idBasedLayoutSingleLinks.add(new LinkArgs(new File(from, blockName), new File(blockLocation, blockName)));
                    ++hl.linkStats.countSingleLinks;
                }
            } else {
                HardLink.createHardLinkMult(from, blockNames, to);
                ++hl.linkStats.countMultLinks;
                hl.linkStats.countFilesMultLinks += blockNames.length;
            }
        } else {
            ++hl.linkStats.countEmptyDirs;
        }
        String[] otherNames = from.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(DataStorage.BLOCK_SUBDIR_PREFIX) || name.startsWith(DataStorage.COPY_FILE_PREFIX);
            }
        });
        for (int i = 0; i < otherNames.length; ++i) {
            DataStorage.linkBlocksHelper(new File(from, otherNames[i]), new File(to, otherNames[i]), oldLV, hl, upgradeToIdBasedLayout, blockRoot, idBasedLayoutSingleLinks);
        }
    }

    private void addBlockPoolStorage(String bpID, BlockPoolSliceStorage bpStorage) {
        if (!this.bpStorageMap.containsKey(bpID)) {
            this.bpStorageMap.put(bpID, bpStorage);
        }
    }

    synchronized void removeBlockPoolStorage(String bpId) {
        this.bpStorageMap.remove(bpId);
    }

    private static class LinkArgs {
        File src;
        File dst;

        LinkArgs(File src, File dst) {
            this.src = src;
            this.dst = dst;
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class VolumeBuilder {
        private DataStorage storage;
        private Storage.StorageDirectory sd;
        private Map<String, List<Storage.StorageDirectory>> bpStorageDirMap = Maps.newHashMap();

        @VisibleForTesting
        public VolumeBuilder(DataStorage storage, Storage.StorageDirectory sd) {
            this.storage = storage;
            this.sd = sd;
        }

        public final Storage.StorageDirectory getStorageDirectory() {
            return this.sd;
        }

        private void addBpStorageDirectories(String bpid, List<Storage.StorageDirectory> dirs) {
            this.bpStorageDirMap.put(bpid, dirs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void build() {
            assert (this.sd != null);
            DataStorage dataStorage = this.storage;
            synchronized (dataStorage) {
                for (Map.Entry<String, List<Storage.StorageDirectory>> e : this.bpStorageDirMap.entrySet()) {
                    String bpid = e.getKey();
                    BlockPoolSliceStorage bpStorage = (BlockPoolSliceStorage)this.storage.bpStorageMap.get(bpid);
                    assert (bpStorage != null);
                    for (Storage.StorageDirectory bpSd : e.getValue()) {
                        bpStorage.addStorageDir(bpSd);
                    }
                }
                this.storage.addStorageDir(this.sd);
            }
        }
    }
}

