/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.concurrent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.airlift.concurrent.ExtendedSettableFuture;
import io.airlift.units.Duration;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class MoreFutures {
    private MoreFutures() {
    }

    public static <X, Y> void propagateCancellation(ListenableFuture<? extends X> source, Future<? extends Y> destination, boolean mayInterruptIfRunning) {
        source.addListener(() -> {
            if (source.isCancelled()) {
                destination.cancel(mayInterruptIfRunning);
            }
        }, MoreExecutors.directExecutor());
    }

    public static <T> void mirror(ListenableFuture<? extends T> source, final SettableFuture<? super T> destination, boolean mayInterruptIfRunning) {
        Futures.addCallback(source, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(@Nullable T result) {
                destination.set(result);
            }

            public void onFailure(Throwable t) {
                destination.setException(t);
            }
        });
        MoreFutures.propagateCancellation(destination, source, mayInterruptIfRunning);
    }

    public static Throwable unwrapCompletionException(Throwable throwable) {
        if (throwable instanceof CompletionException) {
            return (Throwable)MoreObjects.firstNonNull((Object)throwable.getCause(), (Object)throwable);
        }
        return throwable;
    }

    @Deprecated
    public static <V> CompletableFuture<V> unmodifiableFuture(CompletableFuture<V> future) {
        return MoreFutures.unmodifiableFuture(future, false);
    }

    @Deprecated
    public static <V> CompletableFuture<V> unmodifiableFuture(CompletableFuture<V> future, boolean propagateCancel) {
        Objects.requireNonNull(future, "future is null");
        Function<Boolean, Boolean> onCancelFunction = propagateCancel ? future::cancel : mayInterrupt -> false;
        UnmodifiableCompletableFuture unmodifiableFuture = new UnmodifiableCompletableFuture(onCancelFunction);
        future.whenComplete((value, exception) -> {
            if (exception != null) {
                unmodifiableFuture.internalCompleteExceptionally((Throwable)exception);
            } else {
                unmodifiableFuture.internalComplete(value);
            }
        });
        return unmodifiableFuture;
    }

    @Deprecated
    public static <V> CompletableFuture<V> failedFuture(Throwable throwable) {
        Objects.requireNonNull(throwable, "throwable is null");
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(throwable);
        return future;
    }

    public static <V> V getFutureValue(Future<V> future) {
        return MoreFutures.getFutureValue(future, RuntimeException.class);
    }

    public static <V, E extends Exception> V getFutureValue(Future<V> future, Class<E> exceptionType) throws E {
        Objects.requireNonNull(future, "future is null");
        Objects.requireNonNull(exceptionType, "exceptionType is null");
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            Throwables.propagateIfPossible((Throwable)cause, exceptionType);
            throw new RuntimeException(cause);
        }
    }

    public static <T> Optional<T> tryGetFutureValue(Future<T> future) {
        Objects.requireNonNull(future, "future is null");
        if (!future.isDone()) {
            return Optional.empty();
        }
        return MoreFutures.tryGetFutureValue(future, 0, TimeUnit.MILLISECONDS);
    }

    public static <V> Optional<V> tryGetFutureValue(Future<V> future, int timeout, TimeUnit timeUnit) {
        return MoreFutures.tryGetFutureValue(future, timeout, timeUnit, RuntimeException.class);
    }

    public static <V, E extends Exception> Optional<V> tryGetFutureValue(Future<V> future, int timeout, TimeUnit timeUnit, Class<E> exceptionType) throws E {
        Objects.requireNonNull(future, "future is null");
        Preconditions.checkArgument((timeout >= 0 ? 1 : 0) != 0, (Object)"timeout is negative");
        Objects.requireNonNull(timeUnit, "timeUnit is null");
        Objects.requireNonNull(exceptionType, "exceptionType is null");
        try {
            return Optional.ofNullable(future.get(timeout, timeUnit));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            Throwables.propagateIfPossible((Throwable)cause, exceptionType);
            throw new RuntimeException(cause);
        }
        catch (TimeoutException timeoutException) {
            return Optional.empty();
        }
    }

    public static <V> ListenableFuture<V> whenAnyComplete(Iterable<? extends ListenableFuture<? extends V>> futures) {
        Objects.requireNonNull(futures, "futures is null");
        Preconditions.checkArgument((!Iterables.isEmpty(futures) ? 1 : 0) != 0, (Object)"futures is empty");
        ExtendedSettableFuture<V> firstCompletedFuture = ExtendedSettableFuture.create();
        for (ListenableFuture<V> listenableFuture : futures) {
            firstCompletedFuture.setAsync(listenableFuture);
        }
        return firstCompletedFuture;
    }

    @Deprecated
    public static <V> CompletableFuture<V> firstCompletedFuture(Iterable<? extends CompletionStage<? extends V>> futures) {
        return MoreFutures.firstCompletedFuture(futures, false);
    }

    @Deprecated
    public static <V> CompletableFuture<V> firstCompletedFuture(Iterable<? extends CompletionStage<? extends V>> futures, boolean propagateCancel) {
        Objects.requireNonNull(futures, "futures is null");
        Preconditions.checkArgument((!Iterables.isEmpty(futures) ? 1 : 0) != 0, (Object)"futures is empty");
        CompletableFuture future = new CompletableFuture();
        for (CompletionStage<V> stage : futures) {
            stage.whenComplete((value, exception) -> {
                if (exception != null) {
                    future.completeExceptionally((Throwable)exception);
                } else {
                    future.complete(value);
                }
            });
        }
        if (propagateCancel) {
            future.exceptionally(throwable -> {
                if (throwable instanceof CancellationException) {
                    for (CompletionStage sourceFuture : futures) {
                        if (!(sourceFuture instanceof Future)) continue;
                        ((Future)((Object)sourceFuture)).cancel(true);
                    }
                }
                return null;
            });
        }
        return future;
    }

    @Deprecated
    public static <V> CompletableFuture<List<V>> allAsList(List<CompletableFuture<? extends V>> futures) {
        CompletableFuture<Void> allDoneFuture = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        for (CompletableFuture<V> future : futures) {
            future.whenComplete((v, throwable) -> {
                if (throwable != null) {
                    allDoneFuture.completeExceptionally((Throwable)throwable);
                }
            });
        }
        return MoreFutures.unmodifiableFuture(allDoneFuture.thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList())));
    }

    public static <T> ListenableFuture<T> addTimeout(ListenableFuture<T> future, Callable<T> onTimeout, Duration timeout, ScheduledExecutorService executorService) {
        return Futures.catchingAsync((ListenableFuture)Futures.withTimeout(future, (long)timeout.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS, (ScheduledExecutorService)executorService), TimeoutException.class, timeoutException -> {
            try {
                return Futures.immediateFuture(onTimeout.call());
            }
            catch (Throwable throwable) {
                return Futures.immediateFailedFuture((Throwable)throwable);
            }
        });
    }

    @Deprecated
    public static <T> CompletableFuture<T> addTimeout(CompletableFuture<T> future, Callable<T> onTimeout, Duration timeout, ScheduledExecutorService executorService) {
        Objects.requireNonNull(future, "future is null");
        Objects.requireNonNull(onTimeout, "timeoutValue is null");
        Objects.requireNonNull(timeout, "timeout is null");
        Objects.requireNonNull(executorService, "executorService is null");
        if (future.isDone()) {
            return future;
        }
        UnmodifiableCompletableFuture futureWithTimeout = (UnmodifiableCompletableFuture)MoreFutures.unmodifiableFuture(future, true);
        ScheduledFuture<?> timeoutTaskFuture = executorService.schedule(new TimeoutFutureTask<T>(futureWithTimeout, onTimeout, future), timeout.toMillis(), TimeUnit.MILLISECONDS);
        future.whenCompleteAsync((value, exception) -> timeoutTaskFuture.cancel(false), (Executor)executorService);
        return futureWithTimeout;
    }

    public static <V> CompletableFuture<V> toCompletableFuture(ListenableFuture<V> listenableFuture) {
        Objects.requireNonNull(listenableFuture, "listenableFuture is null");
        final CompletableFuture future = new CompletableFuture();
        future.exceptionally(throwable -> {
            if (throwable instanceof CancellationException) {
                listenableFuture.cancel(true);
            }
            return null;
        });
        Futures.addCallback(listenableFuture, (FutureCallback)new FutureCallback<V>(){

            public void onSuccess(V result) {
                future.complete(result);
            }

            public void onFailure(Throwable t) {
                future.completeExceptionally(t);
            }
        });
        return future;
    }

    public static <V> ListenableFuture<V> toListenableFuture(CompletableFuture<V> completableFuture) {
        Objects.requireNonNull(completableFuture, "completableFuture is null");
        SettableFuture future = SettableFuture.create();
        MoreFutures.propagateCancellation(future, completableFuture, true);
        completableFuture.whenComplete((value, exception) -> {
            if (exception != null) {
                future.setException(exception);
            } else {
                future.set(value);
            }
        });
        return future;
    }

    public static <T> void addExceptionCallback(ListenableFuture<T> future, final Consumer<Throwable> exceptionCallback) {
        Objects.requireNonNull(future, "future is null");
        Objects.requireNonNull(exceptionCallback, "exceptionCallback is null");
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(@Nullable T result) {
            }

            public void onFailure(Throwable t) {
                exceptionCallback.accept(t);
            }
        });
    }

    public static <T> void addExceptionCallback(ListenableFuture<T> future, final Runnable exceptionCallback) {
        Objects.requireNonNull(future, "future is null");
        Objects.requireNonNull(exceptionCallback, "exceptionCallback is null");
        Futures.addCallback(future, (FutureCallback)new FutureCallback<T>(){

            public void onSuccess(@Nullable T result) {
            }

            public void onFailure(Throwable t) {
                exceptionCallback.run();
            }
        });
    }

    private static class TimeoutFutureTask<T>
    implements Runnable {
        private final UnmodifiableCompletableFuture<T> settableFuture;
        private final Callable<T> timeoutValue;
        private final WeakReference<CompletableFuture<T>> futureReference;

        public TimeoutFutureTask(UnmodifiableCompletableFuture<T> settableFuture, Callable<T> timeoutValue, CompletableFuture<T> future) {
            this.settableFuture = settableFuture;
            this.timeoutValue = timeoutValue;
            this.futureReference = new WeakReference<CompletableFuture<CompletableFuture<T>>>(future);
        }

        @Override
        public void run() {
            if (this.settableFuture.isDone()) {
                return;
            }
            try {
                T result = this.timeoutValue.call();
                this.settableFuture.internalComplete(result);
            }
            catch (Throwable t) {
                this.settableFuture.internalCompleteExceptionally(t);
                Throwables.throwIfInstanceOf((Throwable)t, RuntimeException.class);
            }
            Future future = (Future)this.futureReference.get();
            if (future != null) {
                future.cancel(true);
            }
        }
    }

    private static class UnmodifiableCompletableFuture<V>
    extends CompletableFuture<V> {
        private final Function<Boolean, Boolean> onCancel;

        public UnmodifiableCompletableFuture(Function<Boolean, Boolean> onCancel) {
            this.onCancel = Objects.requireNonNull(onCancel, "onCancel is null");
        }

        void internalComplete(V value) {
            super.complete(value);
        }

        void internalCompleteExceptionally(Throwable ex) {
            super.completeExceptionally(ex);
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.onCancel.apply(mayInterruptIfRunning);
        }

        @Override
        public boolean complete(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean completeExceptionally(Throwable ex) {
            if (ex instanceof CancellationException) {
                return this.cancel(false);
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public void obtrudeValue(V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void obtrudeException(Throwable ex) {
            throw new UnsupportedOperationException();
        }
    }
}

