/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.bytes;

import it.unimi.dsi.fastutil.bytes.AbstractByteComparator;
import it.unimi.dsi.fastutil.bytes.ByteComparator;

public class ByteComparators {
    public static final ByteComparator NATURAL_COMPARATOR = new AbstractByteComparator(){

        @Override
        public final int compare(byte a, byte b) {
            return a < b ? -1 : (a == b ? 0 : 1);
        }
    };
    public static final ByteComparator OPPOSITE_COMPARATOR = new AbstractByteComparator(){

        @Override
        public final int compare(byte a, byte b) {
            return -(a < b ? -1 : (a == b ? 0 : 1));
        }
    };

    private ByteComparators() {
    }

    public static ByteComparator oppositeComparator(final ByteComparator c) {
        return new AbstractByteComparator(){
            private final ByteComparator comparator;
            {
                this.comparator = c;
            }

            @Override
            public final int compare(byte a, byte b) {
                return -this.comparator.compare(a, b);
            }
        };
    }
}

