/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.rcfile.text;

import com.facebook.presto.rcfile.ColumnEncoding;
import com.facebook.presto.rcfile.RcFileEncoding;
import com.facebook.presto.rcfile.text.BinaryEncoding;
import com.facebook.presto.rcfile.text.BooleanEncoding;
import com.facebook.presto.rcfile.text.DateEncoding;
import com.facebook.presto.rcfile.text.DecimalEncoding;
import com.facebook.presto.rcfile.text.DoubleEncoding;
import com.facebook.presto.rcfile.text.FloatEncoding;
import com.facebook.presto.rcfile.text.ListEncoding;
import com.facebook.presto.rcfile.text.LongEncoding;
import com.facebook.presto.rcfile.text.MapEncoding;
import com.facebook.presto.rcfile.text.StringEncoding;
import com.facebook.presto.rcfile.text.StructEncoding;
import com.facebook.presto.rcfile.text.TextColumnEncoding;
import com.facebook.presto.rcfile.text.TimestampEncoding;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.List;
import java.util.stream.Collectors;
import org.joda.time.DateTimeZone;

public class TextRcFileEncoding
implements RcFileEncoding {
    public static final byte[] DEFAULT_SEPARATORS = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 11, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 28, 29};
    public static final Slice DEFAULT_NULL_SEQUENCE = Slices.utf8Slice((String)"\\N");
    private final DateTimeZone hiveStorageTimeZone;
    private final Slice nullSequence;
    private final byte[] separators;
    private final Byte escapeByte;
    private final boolean lastColumnTakesRest;

    public TextRcFileEncoding(DateTimeZone hiveStorageTimeZone) {
        this(hiveStorageTimeZone, DEFAULT_NULL_SEQUENCE, DEFAULT_SEPARATORS, null, false);
    }

    public TextRcFileEncoding(DateTimeZone hiveStorageTimeZone, Slice nullSequence, byte[] separators, Byte escapeByte, boolean lastColumnTakesRest) {
        this.hiveStorageTimeZone = hiveStorageTimeZone;
        this.nullSequence = nullSequence;
        this.separators = separators;
        this.escapeByte = escapeByte;
        this.lastColumnTakesRest = lastColumnTakesRest;
    }

    @Override
    public ColumnEncoding booleanEncoding(Type type) {
        return new BooleanEncoding(type, this.nullSequence);
    }

    @Override
    public ColumnEncoding byteEncoding(Type type) {
        return this.longEncoding(type);
    }

    @Override
    public ColumnEncoding shortEncoding(Type type) {
        return this.longEncoding(type);
    }

    @Override
    public ColumnEncoding intEncoding(Type type) {
        return this.longEncoding(type);
    }

    @Override
    public ColumnEncoding longEncoding(Type type) {
        return new LongEncoding(type, this.nullSequence);
    }

    @Override
    public ColumnEncoding decimalEncoding(Type type) {
        return new DecimalEncoding(type, this.nullSequence);
    }

    @Override
    public ColumnEncoding floatEncoding(Type type) {
        return new FloatEncoding(type, this.nullSequence);
    }

    @Override
    public ColumnEncoding doubleEncoding(Type type) {
        return new DoubleEncoding(type, this.nullSequence);
    }

    @Override
    public ColumnEncoding stringEncoding(Type type) {
        return new StringEncoding(type, this.nullSequence, this.escapeByte);
    }

    @Override
    public ColumnEncoding binaryEncoding(Type type) {
        return new BinaryEncoding(type, this.nullSequence);
    }

    @Override
    public ColumnEncoding dateEncoding(Type type) {
        return new DateEncoding(type, this.nullSequence);
    }

    @Override
    public ColumnEncoding timestampEncoding(Type type) {
        return new TimestampEncoding(type, this.nullSequence, this.hiveStorageTimeZone);
    }

    @Override
    public ColumnEncoding listEncoding(Type type, ColumnEncoding elementEncoding) {
        return new ListEncoding(type, this.nullSequence, this.separators, this.escapeByte, (TextColumnEncoding)elementEncoding);
    }

    @Override
    public ColumnEncoding mapEncoding(Type type, ColumnEncoding keyEncoding, ColumnEncoding valueEncoding) {
        return new MapEncoding(type, this.nullSequence, this.separators, this.escapeByte, (TextColumnEncoding)keyEncoding, (TextColumnEncoding)valueEncoding);
    }

    @Override
    public ColumnEncoding structEncoding(Type type, List<ColumnEncoding> fieldEncodings) {
        return new StructEncoding(type, this.nullSequence, this.separators, this.escapeByte, this.lastColumnTakesRest, fieldEncodings.stream().map(TextColumnEncoding.class::cast).collect(Collectors.toList()));
    }
}

