/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.data.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.hive.hcatalog.data.schema.HCatFieldSchema;
import org.apache.hive.hcatalog.data.schema.HCatSchema;

public class HCatSchemaUtils {
    public static CollectionBuilder getStructSchemaBuilder() {
        return new CollectionBuilder();
    }

    public static CollectionBuilder getListSchemaBuilder() {
        return new CollectionBuilder();
    }

    public static MapBuilder getMapSchemaBuilder() {
        return new MapBuilder();
    }

    public static HCatFieldSchema getHCatFieldSchema(FieldSchema fs) throws HCatException {
        String fieldName = fs.getName();
        TypeInfo baseTypeInfo = TypeInfoUtils.getTypeInfoFromTypeString(fs.getType());
        return HCatSchemaUtils.getHCatFieldSchema(fieldName, baseTypeInfo);
    }

    private static HCatFieldSchema getHCatFieldSchema(String fieldName, TypeInfo fieldTypeInfo) throws HCatException {
        HCatFieldSchema hCatFieldSchema;
        ObjectInspector.Category typeCategory = fieldTypeInfo.getCategory();
        if (ObjectInspector.Category.PRIMITIVE == typeCategory) {
            hCatFieldSchema = new HCatFieldSchema(fieldName, (PrimitiveTypeInfo)fieldTypeInfo, null);
        } else if (ObjectInspector.Category.STRUCT == typeCategory) {
            HCatSchema subSchema = HCatSchemaUtils.constructHCatSchema((StructTypeInfo)fieldTypeInfo);
            hCatFieldSchema = new HCatFieldSchema(fieldName, HCatFieldSchema.Type.STRUCT, subSchema, null);
        } else if (ObjectInspector.Category.LIST == typeCategory) {
            HCatSchema subSchema = HCatSchemaUtils.getHCatSchema(((ListTypeInfo)fieldTypeInfo).getListElementTypeInfo());
            hCatFieldSchema = new HCatFieldSchema(fieldName, HCatFieldSchema.Type.ARRAY, subSchema, null);
        } else if (ObjectInspector.Category.MAP == typeCategory) {
            HCatSchema subSchema = HCatSchemaUtils.getHCatSchema(((MapTypeInfo)fieldTypeInfo).getMapValueTypeInfo());
            hCatFieldSchema = HCatFieldSchema.createMapTypeFieldSchema(fieldName, (PrimitiveTypeInfo)((MapTypeInfo)fieldTypeInfo).getMapKeyTypeInfo(), subSchema, null);
        } else {
            throw new TypeNotPresentException(fieldTypeInfo.getTypeName(), null);
        }
        return hCatFieldSchema;
    }

    public static HCatSchema getHCatSchema(Schema schema) throws HCatException {
        return HCatSchemaUtils.getHCatSchema(schema.getFieldSchemas());
    }

    public static HCatSchema getHCatSchema(List<? extends FieldSchema> fslist) throws HCatException {
        CollectionBuilder builder = HCatSchemaUtils.getStructSchemaBuilder();
        for (FieldSchema fieldSchema : fslist) {
            builder.addField(fieldSchema);
        }
        return builder.build();
    }

    private static HCatSchema constructHCatSchema(StructTypeInfo stypeInfo) throws HCatException {
        CollectionBuilder builder = HCatSchemaUtils.getStructSchemaBuilder();
        for (String fieldName : stypeInfo.getAllStructFieldNames()) {
            builder.addField(HCatSchemaUtils.getHCatFieldSchema(fieldName, stypeInfo.getStructFieldTypeInfo(fieldName)));
        }
        return builder.build();
    }

    public static HCatSchema getHCatSchema(TypeInfo typeInfo) throws HCatException {
        HCatSchema hCatSchema;
        ObjectInspector.Category typeCategory = typeInfo.getCategory();
        if (ObjectInspector.Category.PRIMITIVE == typeCategory) {
            hCatSchema = HCatSchemaUtils.getStructSchemaBuilder().addField(new HCatFieldSchema(null, (PrimitiveTypeInfo)typeInfo, null)).build();
        } else if (ObjectInspector.Category.STRUCT == typeCategory) {
            HCatSchema subSchema = HCatSchemaUtils.constructHCatSchema((StructTypeInfo)typeInfo);
            hCatSchema = HCatSchemaUtils.getStructSchemaBuilder().addField(new HCatFieldSchema(null, HCatFieldSchema.Type.STRUCT, subSchema, null)).build();
        } else if (ObjectInspector.Category.LIST == typeCategory) {
            CollectionBuilder builder = HCatSchemaUtils.getListSchemaBuilder();
            builder.addField(HCatSchemaUtils.getHCatFieldSchema(null, ((ListTypeInfo)typeInfo).getListElementTypeInfo()));
            hCatSchema = new HCatSchema(Arrays.asList(new HCatFieldSchema("", HCatFieldSchema.Type.ARRAY, builder.build(), "")));
        } else if (ObjectInspector.Category.MAP == typeCategory) {
            HCatSchema subSchema = HCatSchemaUtils.getHCatSchema(((MapTypeInfo)typeInfo).getMapValueTypeInfo());
            MapBuilder builder = HCatSchemaUtils.getMapSchemaBuilder();
            hCatSchema = builder.withKeyType((PrimitiveTypeInfo)((MapTypeInfo)typeInfo).getMapKeyTypeInfo()).withValueSchema(subSchema).build();
        } else {
            throw new TypeNotPresentException(typeInfo.getTypeName(), null);
        }
        return hCatSchema;
    }

    public static HCatSchema getHCatSchemaFromTypeString(String typeString) throws HCatException {
        return HCatSchemaUtils.getHCatSchema(TypeInfoUtils.getTypeInfoFromTypeString(typeString));
    }

    public static HCatSchema getHCatSchema(String schemaString) throws HCatException {
        if (schemaString == null || schemaString.trim().isEmpty()) {
            return new HCatSchema(new ArrayList<HCatFieldSchema>());
        }
        HCatSchema outerSchema = HCatSchemaUtils.getHCatSchemaFromTypeString("struct<" + schemaString + ">");
        return outerSchema.get(0).getStructSubSchema();
    }

    public static FieldSchema getFieldSchema(HCatFieldSchema hcatFieldSchema) {
        return new FieldSchema(hcatFieldSchema.getName(), hcatFieldSchema.getTypeString(), hcatFieldSchema.getComment());
    }

    public static List<FieldSchema> getFieldSchemas(List<HCatFieldSchema> hcatFieldSchemas) {
        ArrayList<FieldSchema> lfs = new ArrayList<FieldSchema>();
        for (HCatFieldSchema hfs : hcatFieldSchemas) {
            lfs.add(HCatSchemaUtils.getFieldSchema(hfs));
        }
        return lfs;
    }

    public static class MapBuilder
    extends HCatSchemaBuilder {
        PrimitiveTypeInfo keyType = null;
        HCatSchema valueSchema = null;

        @Override
        public HCatSchema build() throws HCatException {
            ArrayList<HCatFieldSchema> fslist = new ArrayList<HCatFieldSchema>();
            fslist.add(HCatFieldSchema.createMapTypeFieldSchema(null, this.keyType, this.valueSchema, null));
            return new HCatSchema(fslist);
        }

        public MapBuilder withValueSchema(HCatSchema valueSchema) {
            this.valueSchema = valueSchema;
            return this;
        }

        public MapBuilder withKeyType(PrimitiveTypeInfo keyType) {
            this.keyType = keyType;
            return this;
        }
    }

    public static class CollectionBuilder
    extends HCatSchemaBuilder {
        List<HCatFieldSchema> fieldSchemas = new ArrayList<HCatFieldSchema>();

        CollectionBuilder() {
        }

        public CollectionBuilder addField(FieldSchema fieldSchema) throws HCatException {
            return this.addField(HCatSchemaUtils.getHCatFieldSchema(fieldSchema));
        }

        public CollectionBuilder addField(HCatFieldSchema fieldColumnSchema) {
            this.fieldSchemas.add(fieldColumnSchema);
            return this;
        }

        @Override
        public HCatSchema build() throws HCatException {
            return new HCatSchema(this.fieldSchemas);
        }
    }

    public static abstract class HCatSchemaBuilder {
        public abstract HCatSchema build() throws HCatException;
    }
}

