/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client.rpc;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import javax.security.sasl.SaslException;
import org.apache.hive.spark.client.rpc.KryoMessageCodec;
import org.apache.hive.spark.client.rpc.Rpc;
import org.apache.hive.spark.client.rpc.RpcConfiguration;

abstract class SaslHandler
extends SimpleChannelInboundHandler<Rpc.SaslMessage>
implements KryoMessageCodec.EncryptionHandler {
    private final Logger LOG;
    private final boolean requiresEncryption;
    private KryoMessageCodec kryo;
    private boolean hasAuthResponse = false;

    protected SaslHandler(RpcConfiguration config) {
        this.requiresEncryption = "auth-conf".equals(config.getSaslOptions().get("javax.security.sasl.qop"));
        this.LOG = LoggerFactory.getLogger(this.getClass());
    }

    void setKryoMessageCodec(KryoMessageCodec kryo) {
        this.kryo = kryo;
    }

    protected final void channelRead0(ChannelHandlerContext ctx, Rpc.SaslMessage msg) throws Exception {
        this.LOG.debug("Handling SASL challenge message...");
        Rpc.SaslMessage response = this.update(msg);
        if (response != null) {
            this.LOG.debug("Sending SASL challenge response...");
            this.hasAuthResponse = true;
            ctx.channel().writeAndFlush((Object)response).sync();
        }
        if (!this.isComplete()) {
            return;
        }
        ctx.channel().pipeline().remove((ChannelHandler)this);
        String qop = this.getNegotiatedProperty("javax.security.sasl.qop");
        this.LOG.debug("SASL negotiation finished with QOP {}.", (Object)qop);
        if ("auth-conf".equals(qop)) {
            this.LOG.info("SASL confidentiality enabled.");
            this.kryo.setEncryptionHandler(this);
        } else {
            if (this.requiresEncryption) {
                throw new SaslException("Encryption required, but SASL negotiation did not set it up.");
            }
            this.dispose();
        }
        this.onComplete();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.dispose();
        super.channelInactive(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!this.isComplete()) {
            this.LOG.info("Exception in SASL negotiation.", cause);
            this.onError(cause);
            ctx.close();
        }
        ctx.fireExceptionCaught(cause);
    }

    protected abstract boolean isComplete();

    protected abstract String getNegotiatedProperty(String var1);

    protected abstract Rpc.SaslMessage update(Rpc.SaslMessage var1) throws IOException;

    protected abstract void onComplete() throws Exception;

    protected abstract void onError(Throwable var1);
}

