/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Footer {
    private final long numberOfRows;
    private final int rowsInRowGroup;
    private final List<StripeInformation> stripes;
    private final List<OrcType> types;
    private final List<ColumnStatistics> fileStats;
    private final Map<String, Slice> userMetadata;

    public Footer(long numberOfRows, int rowsInRowGroup, List<StripeInformation> stripes, List<OrcType> types, List<ColumnStatistics> fileStats, Map<String, Slice> userMetadata) {
        this.numberOfRows = numberOfRows;
        this.rowsInRowGroup = rowsInRowGroup;
        this.stripes = ImmutableList.copyOf((Collection)Objects.requireNonNull(stripes, "stripes is null"));
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.fileStats = ImmutableList.copyOf((Collection)Objects.requireNonNull(fileStats, "columnStatistics is null"));
        Objects.requireNonNull(userMetadata, "userMetadata is null");
        this.userMetadata = ImmutableMap.copyOf((Map)Maps.transformValues(userMetadata, Slices::copyOf));
    }

    public long getNumberOfRows() {
        return this.numberOfRows;
    }

    public int getRowsInRowGroup() {
        return this.rowsInRowGroup;
    }

    public List<StripeInformation> getStripes() {
        return this.stripes;
    }

    public List<OrcType> getTypes() {
        return this.types;
    }

    public List<ColumnStatistics> getFileStats() {
        return this.fileStats;
    }

    public Map<String, Slice> getUserMetadata() {
        return ImmutableMap.copyOf((Map)Maps.transformValues(this.userMetadata, Slices::copyOf));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("numberOfRows", this.numberOfRows).add("rowsInRowGroup", this.rowsInRowGroup).add("stripes", this.stripes).add("types", this.types).add("columnStatistics", this.fileStats).add("userMetadata", this.userMetadata.keySet()).toString();
    }
}

