/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.BinaryStatistics;
import com.facebook.presto.orc.metadata.statistics.BinaryStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.BooleanStatistics;
import com.facebook.presto.orc.metadata.statistics.BooleanStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.DateStatistics;
import com.facebook.presto.orc.metadata.statistics.DateStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.DecimalStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.LongDecimalStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import com.facebook.presto.orc.metadata.statistics.StringStatisticsBuilder;
import com.google.common.base.MoreObjects;
import java.util.List;
import java.util.Objects;

public class ColumnStatistics {
    private final Long numberOfValues;
    private final long minAverageValueSizeInBytes;
    private final BooleanStatistics booleanStatistics;
    private final IntegerStatistics integerStatistics;
    private final DoubleStatistics doubleStatistics;
    private final StringStatistics stringStatistics;
    private final DateStatistics dateStatistics;
    private final DecimalStatistics decimalStatistics;
    private final BinaryStatistics binaryStatistics;
    private final HiveBloomFilter bloomFilter;

    public ColumnStatistics(Long numberOfValues, long minAverageValueSizeInBytes, BooleanStatistics booleanStatistics, IntegerStatistics integerStatistics, DoubleStatistics doubleStatistics, StringStatistics stringStatistics, DateStatistics dateStatistics, DecimalStatistics decimalStatistics, BinaryStatistics binaryStatistics, HiveBloomFilter bloomFilter) {
        this.numberOfValues = numberOfValues;
        this.minAverageValueSizeInBytes = minAverageValueSizeInBytes;
        this.booleanStatistics = booleanStatistics;
        this.integerStatistics = integerStatistics;
        this.doubleStatistics = doubleStatistics;
        this.stringStatistics = stringStatistics;
        this.dateStatistics = dateStatistics;
        this.decimalStatistics = decimalStatistics;
        this.binaryStatistics = binaryStatistics;
        this.bloomFilter = bloomFilter;
    }

    public boolean hasNumberOfValues() {
        return this.numberOfValues != null;
    }

    public long getNumberOfValues() {
        return this.numberOfValues == null ? 0L : this.numberOfValues;
    }

    public boolean hasMinAverageValueSizeInBytes() {
        return this.hasNumberOfValues() && this.numberOfValues > 0L;
    }

    public long getMinAverageValueSizeInBytes() {
        return this.minAverageValueSizeInBytes;
    }

    public BooleanStatistics getBooleanStatistics() {
        return this.booleanStatistics;
    }

    public DateStatistics getDateStatistics() {
        return this.dateStatistics;
    }

    public DoubleStatistics getDoubleStatistics() {
        return this.doubleStatistics;
    }

    public IntegerStatistics getIntegerStatistics() {
        return this.integerStatistics;
    }

    public StringStatistics getStringStatistics() {
        return this.stringStatistics;
    }

    public DecimalStatistics getDecimalStatistics() {
        return this.decimalStatistics;
    }

    public BinaryStatistics getBinaryStatistics() {
        return this.binaryStatistics;
    }

    public HiveBloomFilter getBloomFilter() {
        return this.bloomFilter;
    }

    public ColumnStatistics withBloomFilter(HiveBloomFilter bloomFilter) {
        return new ColumnStatistics(this.numberOfValues, this.minAverageValueSizeInBytes, this.booleanStatistics, this.integerStatistics, this.doubleStatistics, this.stringStatistics, this.dateStatistics, this.decimalStatistics, this.binaryStatistics, bloomFilter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnStatistics that = (ColumnStatistics)o;
        return Objects.equals(this.numberOfValues, that.numberOfValues) && Objects.equals(this.booleanStatistics, that.booleanStatistics) && Objects.equals(this.integerStatistics, that.integerStatistics) && Objects.equals(this.doubleStatistics, that.doubleStatistics) && Objects.equals(this.stringStatistics, that.stringStatistics) && Objects.equals(this.dateStatistics, that.dateStatistics) && Objects.equals(this.decimalStatistics, that.decimalStatistics) && Objects.equals((Object)this.bloomFilter, (Object)that.bloomFilter);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.numberOfValues, this.booleanStatistics, this.integerStatistics, this.doubleStatistics, this.stringStatistics, this.dateStatistics, this.decimalStatistics, this.bloomFilter});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("numberOfValues", (Object)this.numberOfValues).add("booleanStatistics", (Object)this.booleanStatistics).add("integerStatistics", (Object)this.integerStatistics).add("doubleStatistics", (Object)this.doubleStatistics).add("stringStatistics", (Object)this.stringStatistics).add("dateStatistics", (Object)this.dateStatistics).add("decimalStatistics", (Object)this.decimalStatistics).add("bloomFilter", (Object)this.bloomFilter).toString();
    }

    public static ColumnStatistics mergeColumnStatistics(List<ColumnStatistics> stats) {
        long numberOfRows = stats.stream().mapToLong(ColumnStatistics::getNumberOfValues).sum();
        long minAverageValueBytes = 0L;
        if (numberOfRows > 0L) {
            minAverageValueBytes = stats.stream().mapToLong(s -> s.getMinAverageValueSizeInBytes() * s.getNumberOfValues()).sum() / numberOfRows;
        }
        return new ColumnStatistics(numberOfRows, minAverageValueBytes, BooleanStatisticsBuilder.mergeBooleanStatistics(stats).orElse(null), IntegerStatisticsBuilder.mergeIntegerStatistics(stats).orElse(null), DoubleStatisticsBuilder.mergeDoubleStatistics(stats).orElse(null), StringStatisticsBuilder.mergeStringStatistics(stats).orElse(null), DateStatisticsBuilder.mergeDateStatistics(stats).orElse(null), LongDecimalStatisticsBuilder.mergeDecimalStatistics(stats).orElse(null), BinaryStatisticsBuilder.mergeBinaryStatistics(stats).orElse(null), null);
    }
}

