/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.RangeStatistics;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.math.BigDecimal;
import java.util.Objects;

public class DecimalStatistics
implements RangeStatistics<BigDecimal> {
    public static final long DECIMAL_VALUE_BYTES_OVERHEAD = 1L;
    private final BigDecimal minimum;
    private final BigDecimal maximum;

    public DecimalStatistics(BigDecimal minimum, BigDecimal maximum) {
        Preconditions.checkArgument((minimum == null || maximum == null || minimum.compareTo(maximum) <= 0 ? 1 : 0) != 0, (Object)"minimum is not less than maximum");
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public BigDecimal getMin() {
        return this.minimum;
    }

    @Override
    public BigDecimal getMax() {
        return this.maximum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DecimalStatistics that = (DecimalStatistics)o;
        return Objects.equals(this.minimum, that.minimum) && Objects.equals(this.maximum, that.maximum);
    }

    public int hashCode() {
        return Objects.hash(this.minimum, this.maximum);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("minimum", (Object)this.minimum).add("maximum", (Object)this.maximum).toString();
    }
}

