/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.RangeStatistics;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class DoubleStatistics
implements RangeStatistics<Double> {
    public static final long DOUBLE_VALUE_BYTES = 9L;
    private final Double minimum;
    private final Double maximum;

    public DoubleStatistics(Double minimum, Double maximum) {
        Preconditions.checkArgument((minimum == null || !minimum.isNaN() ? 1 : 0) != 0, (Object)"minimum is NaN");
        Preconditions.checkArgument((maximum == null || !maximum.isNaN() ? 1 : 0) != 0, (Object)"maximum is NaN");
        Preconditions.checkArgument((minimum == null || maximum == null || minimum <= maximum ? 1 : 0) != 0, (Object)"minimum is not less than maximum");
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public Double getMin() {
        return this.minimum;
    }

    @Override
    public Double getMax() {
        return this.maximum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleStatistics that = (DoubleStatistics)o;
        return Objects.equals(this.minimum, that.minimum) && Objects.equals(this.maximum, that.maximum);
    }

    public int hashCode() {
        return Objects.hash(this.minimum, this.maximum);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("min", (Object)this.minimum).add("max", (Object)this.maximum).toString();
    }
}

