/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.SliceColumnStatisticsBuilder;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class StringStatisticsBuilder
implements SliceColumnStatisticsBuilder {
    private long nonNullValueCount;
    private Slice minimum;
    private Slice maximum;
    private long sum;

    public long getNonNullValueCount() {
        return this.nonNullValueCount;
    }

    @Override
    public void addValue(Slice value) {
        Objects.requireNonNull(value, "value is null");
        ++this.nonNullValueCount;
        this.sum += (long)value.length();
        this.updateMinMax(value);
    }

    private void updateMinMax(Slice value) {
        if (this.minimum == null) {
            this.minimum = value;
            this.maximum = value;
        } else if (value.compareTo(this.minimum) <= 0) {
            this.minimum = value;
        } else if (value.compareTo(this.maximum) >= 0) {
            this.maximum = value;
        }
    }

    private void addStringStatistics(long valueCount, StringStatistics value) {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(value.getMin(), "value.getMin() is null");
        Objects.requireNonNull(value.getMax(), "value.getMax() is null");
        this.nonNullValueCount += valueCount;
        this.sum += value.getSum();
        this.updateMinMax(value.getMin());
        this.updateMinMax(value.getMax());
    }

    private Optional<StringStatistics> buildStringStatistics() {
        if (this.nonNullValueCount == 0L) {
            return Optional.empty();
        }
        return Optional.of(new StringStatistics(this.minimum, this.maximum, this.sum));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<StringStatistics> stringStatistics = this.buildStringStatistics();
        stringStatistics.ifPresent(s -> Verify.verify((this.nonNullValueCount > 0L ? 1 : 0) != 0));
        return new ColumnStatistics(this.nonNullValueCount, stringStatistics.map(s -> 5L + this.sum / this.nonNullValueCount).orElse(0L), null, null, null, stringStatistics.orElse(null), null, null, null, null);
    }

    public static Optional<StringStatistics> mergeStringStatistics(List<ColumnStatistics> stats) {
        StringStatisticsBuilder stringStatisticsBuilder = new StringStatisticsBuilder();
        for (ColumnStatistics columnStatistics : stats) {
            StringStatistics partialStatistics = columnStatistics.getStringStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            stringStatisticsBuilder.addStringStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return stringStatisticsBuilder.buildStringStatistics();
    }
}

