/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.CoercionPolicy;
import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import java.util.Objects;
import javax.inject.Inject;

public class HiveCoercionPolicy
implements CoercionPolicy {
    private final TypeManager typeManager;

    @Inject
    public HiveCoercionPolicy(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    @Override
    public boolean canCoerce(HiveType fromHiveType, HiveType toHiveType) {
        Type fromType = this.typeManager.getType(fromHiveType.getTypeSignature());
        Type toType = this.typeManager.getType(toHiveType.getTypeSignature());
        if (fromType instanceof VarcharType) {
            return toHiveType.equals(HiveType.HIVE_BYTE) || toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG);
        }
        if (toType instanceof VarcharType) {
            return fromHiveType.equals(HiveType.HIVE_BYTE) || fromHiveType.equals(HiveType.HIVE_SHORT) || fromHiveType.equals(HiveType.HIVE_INT) || fromHiveType.equals(HiveType.HIVE_LONG);
        }
        if (fromHiveType.equals(HiveType.HIVE_BYTE)) {
            return toHiveType.equals(HiveType.HIVE_SHORT) || toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG);
        }
        if (fromHiveType.equals(HiveType.HIVE_SHORT)) {
            return toHiveType.equals(HiveType.HIVE_INT) || toHiveType.equals(HiveType.HIVE_LONG);
        }
        if (fromHiveType.equals(HiveType.HIVE_INT)) {
            return toHiveType.equals(HiveType.HIVE_LONG);
        }
        if (fromHiveType.equals(HiveType.HIVE_FLOAT)) {
            return toHiveType.equals(HiveType.HIVE_DOUBLE);
        }
        return false;
    }
}

