/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveType;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;

public class HiveColumnHandle
implements ColumnHandle {
    public static final int PATH_COLUMN_INDEX = -11;
    public static final String PATH_COLUMN_NAME = "$path";
    public static final HiveType PATH_HIVE_TYPE = HiveType.HIVE_STRING;
    public static final TypeSignature PATH_TYPE_SIGNATURE = PATH_HIVE_TYPE.getTypeSignature();
    public static final int BUCKET_COLUMN_INDEX = -12;
    public static final String BUCKET_COLUMN_NAME = "$bucket";
    public static final HiveType BUCKET_HIVE_TYPE = HiveType.HIVE_INT;
    public static final TypeSignature BUCKET_TYPE_SIGNATURE = BUCKET_HIVE_TYPE.getTypeSignature();
    private static final String UPDATE_ROW_ID_COLUMN_NAME = "$shard_row_id";
    private final String clientId;
    private final String name;
    private final HiveType hiveType;
    private final TypeSignature typeName;
    private final int hiveColumnIndex;
    private final ColumnType columnType;
    private final Optional<String> comment;

    @JsonCreator
    public HiveColumnHandle(@JsonProperty(value="clientId") String clientId, @JsonProperty(value="name") String name, @JsonProperty(value="hiveType") HiveType hiveType, @JsonProperty(value="typeSignature") TypeSignature typeSignature, @JsonProperty(value="hiveColumnIndex") int hiveColumnIndex, @JsonProperty(value="columnType") ColumnType columnType, @JsonProperty(value="comment") Optional<String> comment) {
        this.clientId = Objects.requireNonNull(clientId, "clientId is null");
        this.name = Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument((hiveColumnIndex >= 0 || columnType == ColumnType.PARTITION_KEY || columnType == ColumnType.HIDDEN ? 1 : 0) != 0, (Object)"hiveColumnIndex is negative");
        this.hiveColumnIndex = hiveColumnIndex;
        this.hiveType = Objects.requireNonNull(hiveType, "hiveType is null");
        this.typeName = Objects.requireNonNull(typeSignature, "type is null");
        this.columnType = Objects.requireNonNull(columnType, "columnType is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    @JsonProperty
    public String getClientId() {
        return this.clientId;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public HiveType getHiveType() {
        return this.hiveType;
    }

    @JsonProperty
    public int getHiveColumnIndex() {
        return this.hiveColumnIndex;
    }

    public boolean isPartitionKey() {
        return this.columnType == ColumnType.PARTITION_KEY;
    }

    public boolean isHidden() {
        return this.columnType == ColumnType.HIDDEN;
    }

    public ColumnMetadata getColumnMetadata(TypeManager typeManager) {
        return new ColumnMetadata(this.name, typeManager.getType(this.typeName), null, this.isHidden());
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    @JsonProperty
    public TypeSignature getTypeSignature() {
        return this.typeName;
    }

    @JsonProperty
    public ColumnType getColumnType() {
        return this.columnType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.name, this.hiveColumnIndex, this.hiveType, this.columnType, this.comment});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HiveColumnHandle other = (HiveColumnHandle)obj;
        return Objects.equals(this.clientId, other.clientId) && Objects.equals(this.name, other.name) && Objects.equals(this.hiveColumnIndex, other.hiveColumnIndex) && Objects.equals(this.hiveType, other.hiveType) && Objects.equals((Object)this.columnType, (Object)other.columnType) && Objects.equals(this.comment, other.comment);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("clientId", (Object)this.clientId).add("name", (Object)this.name).add("hiveType", (Object)this.hiveType).add("hiveColumnIndex", this.hiveColumnIndex).add("columnType", (Object)this.columnType).add("comment", this.comment).toString();
    }

    public static HiveColumnHandle updateRowIdHandle(String connectorId) {
        return new HiveColumnHandle(connectorId, UPDATE_ROW_ID_COLUMN_NAME, HiveType.HIVE_LONG, BigintType.BIGINT.getTypeSignature(), -1, ColumnType.HIDDEN, Optional.empty());
    }

    public static HiveColumnHandle pathColumnHandle(String connectorId) {
        return new HiveColumnHandle(connectorId, PATH_COLUMN_NAME, PATH_HIVE_TYPE, PATH_TYPE_SIGNATURE, -11, ColumnType.HIDDEN, Optional.empty());
    }

    public static HiveColumnHandle bucketColumnHandle(String connectorId) {
        return new HiveColumnHandle(connectorId, BUCKET_COLUMN_NAME, BUCKET_HIVE_TYPE, BUCKET_TYPE_SIGNATURE, -12, ColumnType.HIDDEN, Optional.empty());
    }

    public static boolean isPathColumnHandle(HiveColumnHandle column) {
        return column.getHiveColumnIndex() == -11;
    }

    public static boolean isBucketColumnHandle(HiveColumnHandle column) {
        return column.getHiveColumnIndex() == -12;
    }

    public static enum ColumnType {
        PARTITION_KEY,
        REGULAR,
        HIDDEN;

    }
}

