/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HiveBucketing;
import com.facebook.presto.hive.HiveColumnHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class HivePartition {
    public static final String UNPARTITIONED_ID = "<UNPARTITIONED>";
    private final SchemaTableName tableName;
    private final TupleDomain<HiveColumnHandle> effectivePredicate;
    private final String partitionId;
    private final Map<ColumnHandle, NullableValue> keys;
    private final List<HiveBucketing.HiveBucket> buckets;

    public HivePartition(SchemaTableName tableName, TupleDomain<HiveColumnHandle> effectivePredicate, List<HiveBucketing.HiveBucket> buckets) {
        this(tableName, effectivePredicate, UNPARTITIONED_ID, (Map<ColumnHandle, NullableValue>)ImmutableMap.of(), buckets);
    }

    public HivePartition(SchemaTableName tableName, TupleDomain<HiveColumnHandle> effectivePredicate, String partitionId, Map<ColumnHandle, NullableValue> keys, List<HiveBucketing.HiveBucket> buckets) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.partitionId = Objects.requireNonNull(partitionId, "partitionId is null");
        this.keys = ImmutableMap.copyOf(Objects.requireNonNull(keys, "keys is null"));
        this.buckets = Objects.requireNonNull(buckets, "bucket number is null");
    }

    public SchemaTableName getTableName() {
        return this.tableName;
    }

    public TupleDomain<HiveColumnHandle> getEffectivePredicate() {
        return this.effectivePredicate;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public Map<ColumnHandle, NullableValue> getKeys() {
        return this.keys;
    }

    public List<HiveBucketing.HiveBucket> getBuckets() {
        return this.buckets;
    }

    public int hashCode() {
        return Objects.hash(this.partitionId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HivePartition other = (HivePartition)obj;
        return Objects.equals(this.partitionId, other.partitionId);
    }

    public String toString() {
        return this.tableName + ":" + this.partitionId;
    }
}

