/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.HivePageSourceProvider;
import com.facebook.presto.hive.HiveUtil;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.Varchars;
import com.google.common.annotations.VisibleForTesting;
import io.airlift.slice.Slice;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class HiveRecordCursor
implements RecordCursor {
    private final RecordCursor delegate;
    private final List<HivePageSourceProvider.ColumnMapping> columnMappings;
    private final Type[] types;
    private final boolean[] booleans;
    private final long[] longs;
    private final double[] doubles;
    private final Slice[] slices;
    private final Object[] objects;
    private final boolean[] nulls;

    public HiveRecordCursor(List<HivePageSourceProvider.ColumnMapping> columnMappings, DateTimeZone hiveStorageTimeZone, TypeManager typeManager, RecordCursor delegate) {
        Objects.requireNonNull(columnMappings, "columns is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        Objects.requireNonNull(hiveStorageTimeZone, "hiveStorageTimeZone is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.columnMappings = columnMappings;
        int size = columnMappings.size();
        this.types = new Type[size];
        this.booleans = new boolean[size];
        this.longs = new long[size];
        this.doubles = new double[size];
        this.slices = new Slice[size];
        this.objects = new Object[size];
        this.nulls = new boolean[size];
        for (int columnIndex = 0; columnIndex < size; ++columnIndex) {
            Type type;
            HivePageSourceProvider.ColumnMapping columnMapping = columnMappings.get(columnIndex);
            if (!columnMapping.isPrefilled()) continue;
            String columnValue = columnMapping.getPrefilledValue();
            byte[] bytes = columnValue.getBytes(StandardCharsets.UTF_8);
            String name = columnMapping.getHiveColumnHandle().getName();
            this.types[columnIndex] = type = typeManager.getType(columnMapping.getHiveColumnHandle().getTypeSignature());
            if (HiveUtil.isHiveNull(bytes)) {
                this.nulls[columnIndex] = true;
                continue;
            }
            if (BooleanType.BOOLEAN.equals((Object)type)) {
                this.booleans[columnIndex] = HiveUtil.booleanPartitionKey(columnValue, name);
                continue;
            }
            if (TinyintType.TINYINT.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.tinyintPartitionKey(columnValue, name);
                continue;
            }
            if (SmallintType.SMALLINT.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.smallintPartitionKey(columnValue, name);
                continue;
            }
            if (IntegerType.INTEGER.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.integerPartitionKey(columnValue, name);
                continue;
            }
            if (BigintType.BIGINT.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.bigintPartitionKey(columnValue, name);
                continue;
            }
            if (RealType.REAL.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.floatPartitionKey(columnValue, name);
                continue;
            }
            if (DoubleType.DOUBLE.equals((Object)type)) {
                this.doubles[columnIndex] = HiveUtil.doublePartitionKey(columnValue, name);
                continue;
            }
            if (Varchars.isVarcharType((Type)type)) {
                this.slices[columnIndex] = HiveUtil.varcharPartitionKey(columnValue, name, type);
                continue;
            }
            if (Chars.isCharType((Type)type)) {
                this.slices[columnIndex] = HiveUtil.charPartitionKey(columnValue, name, type);
                continue;
            }
            if (DateType.DATE.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.datePartitionKey(columnValue, name);
                continue;
            }
            if (TimestampType.TIMESTAMP.equals((Object)type)) {
                this.longs[columnIndex] = HiveUtil.timestampPartitionKey(columnValue, hiveStorageTimeZone, name);
                continue;
            }
            if (Decimals.isShortDecimal((Type)type)) {
                this.longs[columnIndex] = HiveUtil.shortDecimalPartitionKey(columnValue, (DecimalType)type, name);
                continue;
            }
            if (Decimals.isLongDecimal((Type)type)) {
                this.slices[columnIndex] = HiveUtil.longDecimalPartitionKey(columnValue, (DecimalType)type, name);
                continue;
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s for prefilled column: %s", type.getDisplayName(), name));
        }
    }

    public long getTotalBytes() {
        return this.delegate.getTotalBytes();
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public Type getType(int field) {
        return this.types[field];
    }

    public boolean advanceNextPosition() {
        return this.delegate.advanceNextPosition();
    }

    public boolean getBoolean(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (!columnMapping.isPrefilled()) {
            return this.delegate.getBoolean(columnMapping.getIndex());
        }
        return this.booleans[field];
    }

    public long getLong(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (!columnMapping.isPrefilled()) {
            return this.delegate.getLong(columnMapping.getIndex());
        }
        return this.longs[field];
    }

    public double getDouble(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (!columnMapping.isPrefilled()) {
            return this.delegate.getDouble(columnMapping.getIndex());
        }
        return this.doubles[field];
    }

    public Slice getSlice(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (!columnMapping.isPrefilled()) {
            return this.delegate.getSlice(columnMapping.getIndex());
        }
        return this.slices[field];
    }

    public Object getObject(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (!columnMapping.isPrefilled()) {
            return this.delegate.getObject(columnMapping.getIndex());
        }
        return this.objects[field];
    }

    public boolean isNull(int field) {
        HivePageSourceProvider.ColumnMapping columnMapping = this.columnMappings.get(field);
        if (!columnMapping.isPrefilled()) {
            return this.delegate.isNull(columnMapping.getIndex());
        }
        return this.nulls[field];
    }

    public void close() {
        this.delegate.close();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public long getSystemMemoryUsage() {
        return this.delegate.getSystemMemoryUsage();
    }

    @VisibleForTesting
    RecordCursor getRegularColumnRecordCursor() {
        return this.delegate;
    }
}

