/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.facebook.presto.hive.metastore.HiveColumnStatistics;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalLong;

public class PartitionStatistics {
    public static final PartitionStatistics EMPTY_STATISTICS = new PartitionStatistics(false, OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty(), OptionalLong.empty(), (Map<String, HiveColumnStatistics>)ImmutableMap.of());
    private final boolean columnStatsAcurate;
    private final OptionalLong fileCount;
    private final OptionalLong rowCount;
    private final OptionalLong rawDataSize;
    private final OptionalLong totalSize;
    private final Map<String, HiveColumnStatistics> columnStatistics;

    public PartitionStatistics(boolean columnStatsAcurate, OptionalLong fileCount, OptionalLong rowCount, OptionalLong rawDataSize, OptionalLong totalSize, Map<String, HiveColumnStatistics> columnStatistics) {
        this.columnStatsAcurate = columnStatsAcurate;
        this.fileCount = fileCount;
        this.rowCount = rowCount;
        this.rawDataSize = rawDataSize;
        this.totalSize = totalSize;
        this.columnStatistics = ImmutableMap.copyOf(Objects.requireNonNull(columnStatistics, "columnStatistics can not be null"));
    }

    public boolean isColumnStatsAcurate() {
        return this.columnStatsAcurate;
    }

    public OptionalLong getFileCount() {
        return this.fileCount;
    }

    public OptionalLong getRowCount() {
        return this.rowCount;
    }

    public OptionalLong getRawDataSize() {
        return this.rawDataSize;
    }

    public OptionalLong getTotalSize() {
        return this.totalSize;
    }

    public Map<String, HiveColumnStatistics> getColumnStatistics() {
        return this.columnStatistics;
    }
}

