/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.TimingInfo;
import com.facebook.presto.hive.PrestoS3FileSystemStats;
import io.airlift.units.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class PrestoS3FileSystemMetricCollector
extends RequestMetricCollector {
    private final PrestoS3FileSystemStats stats;

    public PrestoS3FileSystemMetricCollector(PrestoS3FileSystemStats stats) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
    }

    public void collectMetrics(Request<?> request, Response<?> response) {
        AWSRequestMetrics metrics = request.getAWSRequestMetrics();
        TimingInfo timingInfo = metrics.getTimingInfo();
        Number requestCounts = timingInfo.getCounter(AWSRequestMetrics.Field.RequestCount.name());
        Number retryCounts = timingInfo.getCounter(AWSRequestMetrics.Field.HttpClientRetryCount.name());
        Number throttleExceptions = timingInfo.getCounter(AWSRequestMetrics.Field.ThrottleException.name());
        TimingInfo requestTime = timingInfo.getSubMeasurement(AWSRequestMetrics.Field.HttpRequestTime.name());
        TimingInfo clientExecuteTime = timingInfo.getSubMeasurement(AWSRequestMetrics.Field.ClientExecuteTime.name());
        if (requestCounts != null) {
            this.stats.updateAwsRequestCount(requestCounts.longValue());
        }
        if (retryCounts != null) {
            this.stats.updateAwsRetryCount(retryCounts.longValue());
        }
        if (throttleExceptions != null) {
            this.stats.updateAwsThrottleExceptionsCount(throttleExceptions.longValue());
        }
        if (requestTime != null && requestTime.getTimeTakenMillisIfKnown() != null) {
            this.stats.addAwsRequestTime(new Duration(requestTime.getTimeTakenMillisIfKnown().doubleValue(), TimeUnit.MILLISECONDS));
        }
        if (clientExecuteTime != null && clientExecuteTime.getTimeTakenMillisIfKnown() != null) {
            this.stats.addAwsClientExecuteTime(new Duration(clientExecuteTime.getTimeTakenMillisIfKnown().doubleValue(), TimeUnit.MILLISECONDS));
        }
    }
}

