/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.parquet.memory;

import com.facebook.presto.hive.parquet.memory.AbstractAggregatedMemoryContext;
import com.google.common.base.MoreObjects;
import java.util.Objects;

public class LocalMemoryContext {
    private final AbstractAggregatedMemoryContext parentMemoryContext;
    private long usedBytes;

    public LocalMemoryContext(AbstractAggregatedMemoryContext parentMemoryContext) {
        this.parentMemoryContext = Objects.requireNonNull(parentMemoryContext, "parentMemoryContext is null");
    }

    public long getBytes() {
        return this.usedBytes;
    }

    public void setBytes(long bytes) {
        long oldLocalUsedBytes = this.usedBytes;
        this.usedBytes = bytes;
        this.parentMemoryContext.updateBytes(this.usedBytes - oldLocalUsedBytes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("usedBytes", this.usedBytes).toString();
    }
}

