/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.stats.cardinality;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.airlift.slice.Murmur3Hash128;
import io.airlift.slice.Slice;
import io.airlift.stats.cardinality.DenseHll;
import io.airlift.stats.cardinality.Format;
import io.airlift.stats.cardinality.HllInstance;
import io.airlift.stats.cardinality.SparseHll;
import io.airlift.stats.cardinality.Utils;

public class HyperLogLog {
    private static final int MAX_NUMBER_OF_BUCKETS = 65536;
    private HllInstance instance;

    private HyperLogLog(HllInstance instance) {
        this.instance = instance;
    }

    public static HyperLogLog newInstance(int numberOfBuckets) {
        Preconditions.checkArgument((numberOfBuckets <= 65536 ? 1 : 0) != 0, (String)"numberOfBuckets must be <= %s, actual: %s", (int)65536, (int)numberOfBuckets);
        return new HyperLogLog(new SparseHll(Utils.indexBitLength(numberOfBuckets)));
    }

    public static HyperLogLog newInstance(Slice serialized) {
        Preconditions.checkArgument((serialized.getByte(0) != Format.SPARSE_V1.getTag() ? 1 : 0) != 0, (Object)"Sparse v1 encoding no longer supported");
        if (SparseHll.canDeserialize(serialized)) {
            return new HyperLogLog(new SparseHll(serialized));
        }
        if (DenseHll.canDeserialize(serialized)) {
            return new HyperLogLog(new DenseHll(serialized));
        }
        throw new IllegalArgumentException("Cannot deserialize HyperLogLog");
    }

    public void add(long value) {
        this.addHash(Murmur3Hash128.hash64((long)value));
    }

    public void add(Slice value) {
        this.addHash(Murmur3Hash128.hash64((Slice)value));
    }

    public void addHash(long hash) {
        this.instance.insertHash(hash);
        if (this.instance instanceof SparseHll) {
            this.instance = HyperLogLog.makeDenseIfNecessary((SparseHll)this.instance);
        }
    }

    public void mergeWith(HyperLogLog other) {
        if (this.instance instanceof SparseHll && other.instance instanceof SparseHll) {
            ((SparseHll)this.instance).mergeWith((SparseHll)other.instance);
            this.instance = HyperLogLog.makeDenseIfNecessary((SparseHll)this.instance);
        } else {
            DenseHll dense = this.instance.toDense();
            dense.mergeWith(other.instance.toDense());
            this.instance = dense;
        }
    }

    public long cardinality() {
        return this.instance.cardinality();
    }

    public int estimatedInMemorySize() {
        return this.instance.estimatedInMemorySize();
    }

    public int estimatedSerializedSize() {
        return this.instance.estimatedSerializedSize();
    }

    public Slice serialize() {
        return this.instance.serialize();
    }

    public void makeDense() {
        this.instance = this.instance.toDense();
    }

    @VisibleForTesting
    void verify() {
        this.instance.verify();
    }

    private static HllInstance makeDenseIfNecessary(SparseHll instance) {
        if (instance.estimatedInMemorySize() > DenseHll.estimatedInMemorySize(instance.getIndexBitLength())) {
            return instance.toDense();
        }
        return instance;
    }
}

