/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.org.apache.http.client.protocol;

import com.facebook.presto.hadoop.;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import com.facebook.presto.hadoop.$internal.org.apache.http.HttpException;
import com.facebook.presto.hadoop.$internal.org.apache.http.HttpHost;
import com.facebook.presto.hadoop.$internal.org.apache.http.HttpRequest;
import com.facebook.presto.hadoop.$internal.org.apache.http.HttpRequestInterceptor;
import com.facebook.presto.hadoop.$internal.org.apache.http.auth.AuthProtocolState;
import com.facebook.presto.hadoop.$internal.org.apache.http.auth.AuthScheme;
import com.facebook.presto.hadoop.$internal.org.apache.http.auth.AuthScope;
import com.facebook.presto.hadoop.$internal.org.apache.http.auth.AuthState;
import com.facebook.presto.hadoop.$internal.org.apache.http.auth.Credentials;
import com.facebook.presto.hadoop.$internal.org.apache.http.client.AuthCache;
import com.facebook.presto.hadoop.$internal.org.apache.http.client.CredentialsProvider;
import com.facebook.presto.hadoop.$internal.org.apache.http.conn.scheme.Scheme;
import com.facebook.presto.hadoop.$internal.org.apache.http.conn.scheme.SchemeRegistry;
import com.facebook.presto.hadoop.$internal.org.apache.http.protocol.HttpContext;
import java.io.IOException;

@.Immutable
public class RequestAuthCache
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        AuthScheme authScheme;
        AuthScheme authScheme2;
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("HTTP context may not be null");
        }
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        if (authCache == null) {
            this.log.debug("Auth cache not set in the context");
            return;
        }
        CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
        if (credsProvider == null) {
            this.log.debug("Credentials provider not set in the context");
            return;
        }
        HttpHost target = (HttpHost)context.getAttribute("http.target_host");
        if (target.getPort() < 0) {
            SchemeRegistry schemeRegistry = (SchemeRegistry)context.getAttribute("http.scheme-registry");
            Scheme scheme = schemeRegistry.getScheme(target);
            target = new HttpHost(target.getHostName(), scheme.resolvePort(target.getPort()), target.getSchemeName());
        }
        AuthState targetState = (AuthState)context.getAttribute("http.auth.target-scope");
        if (target != null && targetState != null && targetState.getState() == AuthProtocolState.UNCHALLENGED && (authScheme2 = authCache.get(target)) != null) {
            this.doPreemptiveAuth(target, authScheme2, targetState, credsProvider);
        }
        HttpHost proxy = (HttpHost)context.getAttribute("http.proxy_host");
        AuthState proxyState = (AuthState)context.getAttribute("http.auth.proxy-scope");
        if (proxy != null && proxyState != null && proxyState.getState() == AuthProtocolState.UNCHALLENGED && (authScheme = authCache.get(proxy)) != null) {
            this.doPreemptiveAuth(proxy, authScheme, proxyState, credsProvider);
        }
    }

    private void doPreemptiveAuth(HttpHost host, AuthScheme authScheme, AuthState authState, CredentialsProvider credsProvider) {
        AuthScope authScope;
        Credentials creds;
        String schemeName = authScheme.getSchemeName();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Re-using cached '" + schemeName + "' auth scheme for " + host);
        }
        if ((creds = credsProvider.getCredentials(authScope = new AuthScope(host, AuthScope.ANY_REALM, schemeName))) != null) {
            if ("BASIC".equalsIgnoreCase(authScheme.getSchemeName())) {
                authState.setState(AuthProtocolState.CHALLENGED);
            } else {
                authState.setState(AuthProtocolState.SUCCESS);
            }
            authState.update(authScheme, creds);
        } else {
            this.log.debug("No credentials for preemptive authentication");
        }
    }
}

