/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.facebook.presto.hadoop.$internal.org.apache.commons.io.Charsets;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class HostsFileReader {
    private Set<String> includes = new HashSet<String>();
    private Set<String> excludes = new HashSet<String>();
    private String includesFile;
    private String excludesFile;
    private static final Log LOG = LogFactory.getLog(HostsFileReader.class);

    public HostsFileReader(String inFile, String exFile) throws IOException {
        this.includesFile = inFile;
        this.excludesFile = exFile;
        this.refresh();
    }

    @InterfaceAudience.Private
    public HostsFileReader(String includesFile, InputStream inFileInputStream, String excludesFile, InputStream exFileInputStream) throws IOException {
        this.includesFile = includesFile;
        this.excludesFile = excludesFile;
        this.refresh(inFileInputStream, exFileInputStream);
    }

    public static void readFileToSet(String type, String filename, Set<String> set) throws IOException {
        File file = new File(filename);
        FileInputStream fis = new FileInputStream(file);
        HostsFileReader.readFileToSetWithFileInputStream(type, filename, fis, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    public static void readFileToSetWithFileInputStream(String type, String filename, InputStream fileInputStream, Set<String> set) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(fileInputStream, Charsets.UTF_8));
            while ((line = reader.readLine()) != null) {
                String[] nodes = line.split("[ \t\n\f\r]+");
                if (nodes == null) continue;
                for (int i = 0; i < nodes.length && !nodes[i].trim().startsWith("#"); ++i) {
                    if (nodes[i].isEmpty()) continue;
                    LOG.info("Adding " + nodes[i] + " to the list of " + type + " hosts from " + filename);
                    set.add(nodes[i]);
                }
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            fileInputStream.close();
        }
    }

    public synchronized void refresh() throws IOException {
        LOG.info("Refreshing hosts (include/exclude) list");
        HashSet<String> newIncludes = new HashSet<String>();
        HashSet<String> newExcludes = new HashSet<String>();
        boolean switchIncludes = false;
        boolean switchExcludes = false;
        if (!this.includesFile.isEmpty()) {
            HostsFileReader.readFileToSet("included", this.includesFile, newIncludes);
            switchIncludes = true;
        }
        if (!this.excludesFile.isEmpty()) {
            HostsFileReader.readFileToSet("excluded", this.excludesFile, newExcludes);
            switchExcludes = true;
        }
        if (switchIncludes) {
            this.includes = newIncludes;
        }
        if (switchExcludes) {
            this.excludes = newExcludes;
        }
    }

    @InterfaceAudience.Private
    public synchronized void refresh(InputStream inFileInputStream, InputStream exFileInputStream) throws IOException {
        LOG.info("Refreshing hosts (include/exclude) list");
        HashSet<String> newIncludes = new HashSet<String>();
        HashSet<String> newExcludes = new HashSet<String>();
        boolean switchIncludes = false;
        boolean switchExcludes = false;
        if (inFileInputStream != null) {
            HostsFileReader.readFileToSetWithFileInputStream("included", this.includesFile, inFileInputStream, newIncludes);
            switchIncludes = true;
        }
        if (exFileInputStream != null) {
            HostsFileReader.readFileToSetWithFileInputStream("excluded", this.excludesFile, exFileInputStream, newExcludes);
            switchExcludes = true;
        }
        if (switchIncludes) {
            this.includes = newIncludes;
        }
        if (switchExcludes) {
            this.excludes = newExcludes;
        }
    }

    public synchronized Set<String> getHosts() {
        return this.includes;
    }

    public synchronized Set<String> getExcludedHosts() {
        return this.excludes;
    }

    public synchronized void setIncludesFile(String includesFile) {
        LOG.info("Setting the includes file to " + includesFile);
        this.includesFile = includesFile;
    }

    public synchronized void setExcludesFile(String excludesFile) {
        LOG.info("Setting the excludes file to " + excludesFile);
        this.excludesFile = excludesFile;
    }

    public synchronized void updateFileNames(String includesFile, String excludesFile) {
        this.setIncludesFile(includesFile);
        this.setExcludesFile(excludesFile);
    }
}

