/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.array;

import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import org.openjdk.jol.info.ClassLayout;

public final class ReferenceCountMap
extends Object2IntOpenCustomHashMap<Object> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ReferenceCountMap.class).instanceSize();

    public ReferenceCountMap() {
        super((Hash.Strategy)new ObjectStrategy());
    }

    public int incrementReference(Object key) {
        return this.addTo(key, 1) + 1;
    }

    public int decrementReference(Object key) {
        int previousCount = this.addTo(key, -1);
        if (previousCount == 1) {
            this.remove(key);
        }
        return previousCount - 1;
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.key) + SizeOf.sizeOf((int[])this.value) + SizeOf.sizeOf((boolean[])this.used);
    }

    private static final class ObjectStrategy
    implements Hash.Strategy<Object> {
        private ObjectStrategy() {
        }

        public int hashCode(Object object) {
            return System.identityHashCode(object);
        }

        public boolean equals(Object left, Object right) {
            return left == right;
        }
    }
}

