/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.array;

import com.facebook.presto.array.ObjectBigArray;
import io.airlift.slice.Slice;
import org.openjdk.jol.info.ClassLayout;

public final class SliceBigArray {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceBigArray.class).instanceSize();
    private static final int SLICE_INSTANCE_SIZE = ClassLayout.parseClass(Slice.class).instanceSize();
    private final ObjectBigArray<Slice> array;
    private long sizeOfSlices;

    public SliceBigArray() {
        this.array = new ObjectBigArray();
    }

    public SliceBigArray(Slice slice) {
        this.array = new ObjectBigArray(slice);
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + this.array.sizeOf() + this.sizeOfSlices;
    }

    public Slice get(long index) {
        return this.array.get(index);
    }

    public void set(long index, Slice value) {
        Slice currentValue = this.array.get(index);
        if (currentValue != null) {
            this.sizeOfSlices -= this.getSize(currentValue);
        }
        if (value != null) {
            this.sizeOfSlices += this.getSize(value);
        }
        this.array.set(index, value);
    }

    private long getSize(Slice slice) {
        return slice.length() + SLICE_INSTANCE_SIZE;
    }

    public void ensureCapacity(long length) {
        this.array.ensureCapacity(length);
    }
}

