/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.net.URI;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;

public class HttpSenderOverHTTP2
extends HttpSender {
    public HttpSenderOverHTTP2(HttpChannelOverHTTP2 channel) {
        super((HttpChannel)channel);
    }

    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    protected void sendHeaders(HttpExchange exchange, HttpContent content, Callback callback) {
        HttpRequest request = exchange.getRequest();
        String path = this.relativize(request.getPath());
        HttpURI uri = new HttpURI(request.getScheme(), request.getHost(), request.getPort(), path, null, request.getQuery(), null);
        MetaData.Request metaData = new MetaData.Request(request.getMethod(), uri, HttpVersion.HTTP_2, request.getHeaders());
        HeadersFrame headersFrame = new HeadersFrame((MetaData)metaData, null, !content.hasContent());
        HttpChannelOverHTTP2 channel = this.getHttpChannel();
        Promise<Stream> promise = new Promise<Stream>((Request)request, content, callback){
            final /* synthetic */ Request val$request;
            final /* synthetic */ HttpContent val$content;
            final /* synthetic */ Callback val$callback;
            {
                this.val$request = request;
                this.val$content = httpContent;
                this.val$callback = callback;
            }

            public void succeeded(Stream stream) {
                HttpSenderOverHTTP2.this.getHttpChannel().setStream(stream);
                stream.setIdleTimeout(this.val$request.getIdleTimeout());
                if (this.val$content.hasContent() && !HttpSenderOverHTTP2.this.expects100Continue(this.val$request)) {
                    boolean advanced = this.val$content.advance();
                    boolean lastContent = this.val$content.isLast();
                    if (advanced || lastContent) {
                        DataFrame dataFrame = new DataFrame(stream.getId(), this.val$content.getByteBuffer(), lastContent);
                        stream.data(dataFrame, this.val$callback);
                        return;
                    }
                }
                this.val$callback.succeeded();
            }

            public void failed(Throwable failure) {
                this.val$callback.failed(failure);
            }
        };
        channel.getSession().newStream(headersFrame, (Promise)promise, channel.getStreamListener());
    }

    private String relativize(String path) {
        try {
            String result = path;
            URI uri = URI.create(result);
            if (uri.isAbsolute()) {
                result = uri.getPath();
            }
            return result.isEmpty() ? "/" : result;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not relativize " + path, new Object[0]);
            }
            return path;
        }
    }

    protected void sendContent(HttpExchange exchange, HttpContent content, Callback callback) {
        if (content.isConsumed()) {
            callback.succeeded();
        } else {
            Stream stream = this.getHttpChannel().getStream();
            DataFrame frame = new DataFrame(stream.getId(), content.getByteBuffer(), content.isLast());
            stream.data(frame, callback);
        }
    }
}

