/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.json;

import com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.JsonLocation;
import com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.JsonStreamContext;
import com.facebook.presto.hadoop.$internal.com.fasterxml.jackson.core.io.CharTypes;

public final class JsonReadContext
extends JsonStreamContext {
    protected final JsonReadContext _parent;
    protected int _lineNr;
    protected int _columnNr;
    protected String _currentName;
    protected JsonReadContext _child = null;

    public JsonReadContext(JsonReadContext jsonReadContext, int n, int n2, int n3) {
        this._type = n;
        this._parent = jsonReadContext;
        this._lineNr = n2;
        this._columnNr = n3;
        this._index = -1;
    }

    protected void reset(int n, int n2, int n3) {
        this._type = n;
        this._index = -1;
        this._lineNr = n2;
        this._columnNr = n3;
        this._currentName = null;
    }

    public static JsonReadContext createRootContext(int n, int n2) {
        return new JsonReadContext(null, 0, n, n2);
    }

    public static JsonReadContext createRootContext() {
        return new JsonReadContext(null, 0, 1, 0);
    }

    public JsonReadContext createChildArrayContext(int n, int n2) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            this._child = jsonReadContext = new JsonReadContext(this, 1, n, n2);
            return jsonReadContext;
        }
        jsonReadContext.reset(1, n, n2);
        return jsonReadContext;
    }

    public JsonReadContext createChildObjectContext(int n, int n2) {
        JsonReadContext jsonReadContext = this._child;
        if (jsonReadContext == null) {
            this._child = jsonReadContext = new JsonReadContext(this, 2, n, n2);
            return jsonReadContext;
        }
        jsonReadContext.reset(2, n, n2);
        return jsonReadContext;
    }

    @Override
    public String getCurrentName() {
        return this._currentName;
    }

    @Override
    public JsonReadContext getParent() {
        return this._parent;
    }

    public JsonLocation getStartLocation(Object object) {
        long l = -1L;
        return new JsonLocation(object, l, this._lineNr, this._columnNr);
    }

    public boolean expectComma() {
        int n = ++this._index;
        return this._type != 0 && n > 0;
    }

    public void setCurrentName(String string) {
        this._currentName = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                stringBuilder.append("/");
                break;
            }
            case 1: {
                stringBuilder.append('[');
                stringBuilder.append(this.getCurrentIndex());
                stringBuilder.append(']');
                break;
            }
            case 2: {
                stringBuilder.append('{');
                if (this._currentName != null) {
                    stringBuilder.append('\"');
                    CharTypes.appendQuoted(stringBuilder, this._currentName);
                    stringBuilder.append('\"');
                } else {
                    stringBuilder.append('?');
                }
                stringBuilder.append('}');
            }
        }
        return stringBuilder.toString();
    }
}

