/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage;

import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageExtendedErrorInformation;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class StorageErrorHandler
extends DefaultHandler {
    private final Stack<String> elementStack = new Stack();
    private StringBuilder bld = new StringBuilder();
    private final StorageExtendedErrorInformation errorInfo = new StorageExtendedErrorInformation();

    StorageErrorHandler() {
    }

    public static StorageExtendedErrorInformation getExtendedErrorInformation(InputStream stream) throws SAXException, IOException, ParserConfigurationException {
        SAXParser saxParser = Utility.getSAXParser();
        StorageErrorHandler handler = new StorageErrorHandler();
        saxParser.parse(stream, (DefaultHandler)handler);
        return handler.errorInfo;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value;
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        String parentNode = null;
        if (!this.elementStack.isEmpty()) {
            parentNode = this.elementStack.peek();
        }
        if ((value = this.bld.toString()).isEmpty()) {
            value = null;
        }
        if ("Error".equals(parentNode)) {
            if ("Code".equals(currentNode)) {
                this.errorInfo.setErrorCode(value);
            } else if ("Message".equals(currentNode)) {
                this.errorInfo.setErrorMessage(value);
            } else {
                this.errorInfo.getAdditionalDetails().put(currentNode, new String[]{value});
            }
        } else if ("ExceptionDetails".equals(parentNode)) {
            this.errorInfo.getAdditionalDetails().put(currentNode, new String[]{value});
        }
        this.bld = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bld.append(ch, start, length);
    }
}

