/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.facebook.presto.hadoop.$internal.com.google.common.base.Strings;
import com.facebook.presto.hadoop.$internal.com.google.common.collect.ImmutableSet;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hadoop.$internal.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.FinalizerService;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.UserGroupInformationShim;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public final class PrestoFileSystemCache
extends FileSystem.Cache {
    public static final Log log = LogFactory.getLog(PrestoFileSystemCache.class);
    private final AtomicLong unique = new AtomicLong();
    private final Map<FileSystemKey, FileSystemHolder> map = new HashMap<FileSystemKey, FileSystemHolder>();

    @Override
    FileSystem get(URI uri, Configuration conf) throws IOException {
        return this.getInternal(uri, conf, 0L);
    }

    @Override
    FileSystem getUnique(URI uri, Configuration conf) throws IOException {
        return this.getInternal(uri, conf, this.unique.incrementAndGet());
    }

    private synchronized FileSystem getInternal(URI uri, Configuration conf, long unique) throws IOException {
        UserGroupInformation userGroupInformation = UserGroupInformation.getCurrentUser();
        FileSystemKey key = PrestoFileSystemCache.createFileSystemKey(uri, userGroupInformation, unique);
        Set<?> privateCredentials = PrestoFileSystemCache.getPrivateCredentials(userGroupInformation);
        FileSystemHolder fileSystemHolder = this.map.get(key);
        if (fileSystemHolder == null) {
            int maxSize = conf.getInt("fs.cache.max-size", 1000);
            if (this.map.size() >= maxSize) {
                throw new IOException(String.format("FileSystem max cache size has been reached: %s", maxSize));
            }
            FileSystem fileSystem = PrestoFileSystemCache.createFileSystem(uri, conf);
            fileSystemHolder = new FileSystemHolder(fileSystem, privateCredentials);
            this.map.put(key, fileSystemHolder);
        }
        if (PrestoFileSystemCache.isHdfs(uri) && !fileSystemHolder.getPrivateCredentials().equals(privateCredentials)) {
            this.map.remove(key);
            FileSystem fileSystem = PrestoFileSystemCache.createFileSystem(uri, conf);
            fileSystemHolder = new FileSystemHolder(fileSystem, privateCredentials);
            this.map.put(key, fileSystemHolder);
        }
        return fileSystemHolder.getFileSystem();
    }

    private static FileSystem createFileSystem(URI uri, Configuration conf) throws IOException {
        Class<? extends FileSystem> clazz = FileSystem.getFileSystemClass(uri.getScheme(), conf);
        if (clazz == null) {
            throw new IOException("No FileSystem for scheme: " + uri.getScheme());
        }
        final FileSystem original = ReflectionUtils.newInstance(clazz, conf);
        original.initialize(uri, conf);
        FileSystemWrapper wrapper = new FileSystemWrapper(original);
        FinalizerService.getInstance().addFinalizer(wrapper, new Runnable(){

            @Override
            public void run() {
                try {
                    original.close();
                }
                catch (IOException e) {
                    log.error("Error occurred when finalizing file system", e);
                }
            }
        });
        return wrapper;
    }

    @Override
    synchronized void remove(FileSystem.Cache.Key ignored, FileSystem fileSystem) {
        if (fileSystem == null) {
            return;
        }
        Iterator<Map.Entry<FileSystemKey, FileSystemHolder>> iterator = this.map.entrySet().iterator();
        while (iterator.hasNext()) {
            if (!fileSystem.equals(iterator.next().getValue().getFileSystem())) continue;
            iterator.remove();
            break;
        }
    }

    @Override
    synchronized void closeAll() throws IOException {
        for (FileSystemHolder fileSystemHolder : this.map.values()) {
            fileSystemHolder.getFileSystem().close();
        }
        this.map.clear();
    }

    @Override
    synchronized void closeAll(boolean onlyAutomatic) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    synchronized void closeAll(UserGroupInformation ugi) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static FileSystemKey createFileSystemKey(URI uri, UserGroupInformation userGroupInformation, long unique) {
        String proxyUser;
        String realUser;
        String scheme = Strings.nullToEmpty(uri.getScheme()).toLowerCase(Locale.ENGLISH);
        String authority = Strings.nullToEmpty(uri.getAuthority()).toLowerCase(Locale.ENGLISH);
        UserGroupInformation.AuthenticationMethod authenticationMethod = userGroupInformation.getAuthenticationMethod();
        switch (authenticationMethod) {
            case SIMPLE: 
            case KERBEROS: {
                realUser = userGroupInformation.getUserName();
                proxyUser = null;
                break;
            }
            case PROXY: {
                realUser = userGroupInformation.getRealUser().getUserName();
                proxyUser = userGroupInformation.getUserName();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported authentication method: " + (Object)((Object)authenticationMethod));
            }
        }
        return new FileSystemKey(scheme, authority, unique, realUser, proxyUser);
    }

    private static Set<?> getPrivateCredentials(UserGroupInformation userGroupInformation) {
        UserGroupInformation.AuthenticationMethod authenticationMethod = userGroupInformation.getAuthenticationMethod();
        switch (authenticationMethod) {
            case SIMPLE: {
                return ImmutableSet.of();
            }
            case KERBEROS: {
                return ImmutableSet.copyOf(UserGroupInformationShim.getSubject(userGroupInformation).getPrivateCredentials());
            }
            case PROXY: {
                return PrestoFileSystemCache.getPrivateCredentials(userGroupInformation.getRealUser());
            }
        }
        throw new IllegalArgumentException("Unsupported authentication method: " + (Object)((Object)authenticationMethod));
    }

    private static boolean isHdfs(URI uri) {
        return "hdfs".equals(uri.getScheme());
    }

    private static class InputStreamWrapper
    extends FSDataInputStream {
        private final FileSystem fileSystem;

        public InputStreamWrapper(FSDataInputStream inputStream, FileSystem fileSystem) {
            super(inputStream);
            this.fileSystem = fileSystem;
        }
    }

    private static class OutputStreamWrapper
    extends FSDataOutputStream {
        private final FileSystem fileSystem;

        public OutputStreamWrapper(FSDataOutputStream delegate, FileSystem fileSystem) throws IOException {
            super(delegate, null, delegate.getPos());
            this.fileSystem = fileSystem;
        }
    }

    private static class FileSystemWrapper
    extends FilterFileSystem {
        public FileSystemWrapper(FileSystem fs) {
            super(fs);
        }

        @Override
        public FSDataInputStream open(Path f, int bufferSize) throws IOException {
            return new InputStreamWrapper(this.getRawFileSystem().open(f, bufferSize), this);
        }

        @Override
        public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
            return new OutputStreamWrapper(this.getRawFileSystem().append(f, bufferSize, progress), this);
        }

        @Override
        public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return new OutputStreamWrapper(this.getRawFileSystem().create(f, permission, overwrite, bufferSize, replication, blockSize, progress), this);
        }

        @Override
        public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
            return new OutputStreamWrapper(this.getRawFileSystem().create(f, permission, flags, bufferSize, replication, blockSize, progress, checksumOpt), this);
        }

        @Override
        public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
            return new OutputStreamWrapper(this.getRawFileSystem().createNonRecursive(f, permission, flags, bufferSize, replication, blockSize, progress), this);
        }
    }

    private static class FileSystemHolder {
        private final FileSystem fileSystem;
        private final Set<?> privateCredentials;

        public FileSystemHolder(FileSystem fileSystem, Set<?> privateCredentials) {
            this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
            this.privateCredentials = ImmutableSet.copyOf((Collection)Objects.requireNonNull(privateCredentials, "privateCredentials is null"));
        }

        public FileSystem getFileSystem() {
            return this.fileSystem;
        }

        public Set<?> getPrivateCredentials() {
            return this.privateCredentials;
        }

        public String toString() {
            return com.facebook.presto.hadoop.$internal.com.google.common.base.Objects.toStringHelper(this).add("fileSystem", this.fileSystem).add("privateCredentials", this.privateCredentials).toString();
        }
    }

    private static class FileSystemKey {
        private final String scheme;
        private final String authority;
        private final long unique;
        private final String realUser;
        private final String proxyUser;

        public FileSystemKey(String scheme, String authority, long unique, String realUser, String proxyUser) {
            this.scheme = Objects.requireNonNull(scheme, "scheme is null");
            this.authority = Objects.requireNonNull(authority, "authority is null");
            this.unique = unique;
            this.realUser = Objects.requireNonNull(realUser, "realUser");
            this.proxyUser = proxyUser;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileSystemKey that = (FileSystemKey)o;
            return Objects.equals(this.scheme, that.scheme) && Objects.equals(this.authority, that.authority) && Objects.equals(this.unique, that.unique) && Objects.equals(this.realUser, that.realUser) && Objects.equals(this.proxyUser, that.proxyUser);
        }

        public int hashCode() {
            return Objects.hash(this.scheme, this.authority, this.unique, this.realUser, this.proxyUser);
        }

        public String toString() {
            return com.facebook.presto.hadoop.$internal.com.google.common.base.Objects.toStringHelper(this).add("scheme", this.scheme).add("authority", this.authority).add("unique", this.unique).add("realUser", this.realUser).add("proxyUser", this.proxyUser).toString();
        }
    }
}

