/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.AccessCondition;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.CloudStorageAccount;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.OperationContext;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.RetryPolicyFactory;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageCredentials;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageException;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.StorageUri;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.BlobListingDetails;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.BlobProperties;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.CloudBlob;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.CloudBlobClient;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.CloudBlobDirectory;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.CloudPageBlob;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.CopyState;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.DeleteSnapshotsOption;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.ListBlobItem;
import com.facebook.presto.hadoop.$internal.com.microsoft.azure.storage.blob.PageRange;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.azure.SelfRenewingLease;
import org.apache.hadoop.fs.azure.StorageInterface;

@InterfaceAudience.Private
class StorageInterfaceImpl
extends StorageInterface {
    private CloudBlobClient serviceClient;

    StorageInterfaceImpl() {
    }

    @Override
    public void setRetryPolicyFactory(RetryPolicyFactory retryPolicyFactory) {
        this.serviceClient.getDefaultRequestOptions().setRetryPolicyFactory(retryPolicyFactory);
    }

    @Override
    public void setTimeoutInMs(int timeoutInMs) {
        this.serviceClient.getDefaultRequestOptions().setTimeoutIntervalInMs(timeoutInMs);
    }

    @Override
    public void createBlobClient(CloudStorageAccount account) {
        this.serviceClient = account.createCloudBlobClient();
    }

    @Override
    public void createBlobClient(URI baseUri) {
        this.serviceClient = new CloudBlobClient(baseUri);
    }

    @Override
    public void createBlobClient(URI baseUri, StorageCredentials credentials) {
        this.serviceClient = new CloudBlobClient(baseUri, credentials);
    }

    @Override
    public StorageCredentials getCredentials() {
        return this.serviceClient.getCredentials();
    }

    @Override
    public StorageInterface.CloudBlobContainerWrapper getContainerReference(String uri) throws URISyntaxException, StorageException {
        return new CloudBlobContainerWrapperImpl(this.serviceClient.getContainerReference(uri));
    }

    static class CloudPageBlobWrapperImpl
    extends CloudBlobWrapperImpl
    implements StorageInterface.CloudPageBlobWrapper {
        public CloudPageBlobWrapperImpl(CloudPageBlob blob) {
            super(blob);
        }

        @Override
        public void create(long length, BlobRequestOptions options, OperationContext opContext) throws StorageException {
            ((CloudPageBlob)this.getBlob()).create(length, null, options, opContext);
        }

        @Override
        public void uploadPages(InputStream sourceStream, long offset, long length, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
            ((CloudPageBlob)this.getBlob()).uploadPages(sourceStream, offset, length, null, options, opContext);
        }

        @Override
        public ArrayList<PageRange> downloadPageRanges(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            return ((CloudPageBlob)this.getBlob()).downloadPageRanges(null, options, opContext);
        }
    }

    static class CloudBlockBlobWrapperImpl
    extends CloudBlobWrapperImpl
    implements StorageInterface.CloudBlockBlobWrapper {
        public CloudBlockBlobWrapperImpl(CloudBlockBlob blob) {
            super(blob);
        }

        @Override
        public OutputStream openOutputStream(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            return ((CloudBlockBlob)this.getBlob()).openOutputStream(null, options, opContext);
        }

        @Override
        public void upload(InputStream sourceStream, OperationContext opContext) throws StorageException, IOException {
            this.getBlob().upload(sourceStream, 0L, null, null, opContext);
        }

        public void uploadProperties(OperationContext opContext) throws StorageException {
            this.getBlob().uploadProperties(null, null, opContext);
        }
    }

    static abstract class CloudBlobWrapperImpl
    implements StorageInterface.CloudBlobWrapper {
        private final CloudBlob blob;

        @Override
        public CloudBlob getBlob() {
            return this.blob;
        }

        @Override
        public URI getUri() {
            return this.getBlob().getUri();
        }

        protected CloudBlobWrapperImpl(CloudBlob blob) {
            this.blob = blob;
        }

        @Override
        public HashMap<String, String> getMetadata() {
            return this.getBlob().getMetadata();
        }

        @Override
        public void delete(OperationContext opContext, SelfRenewingLease lease) throws StorageException {
            this.getBlob().delete(DeleteSnapshotsOption.NONE, this.getLeaseCondition(lease), null, opContext);
        }

        private AccessCondition getLeaseCondition(SelfRenewingLease lease) {
            AccessCondition leaseCondition = null;
            if (lease != null) {
                leaseCondition = AccessCondition.generateLeaseCondition(lease.getLeaseID());
            }
            return leaseCondition;
        }

        @Override
        public boolean exists(OperationContext opContext) throws StorageException {
            return this.getBlob().exists(null, null, opContext);
        }

        @Override
        public void downloadAttributes(OperationContext opContext) throws StorageException {
            this.getBlob().downloadAttributes(null, null, opContext);
        }

        @Override
        public BlobProperties getProperties() {
            return this.getBlob().getProperties();
        }

        @Override
        public void setMetadata(HashMap<String, String> metadata) {
            this.getBlob().setMetadata(metadata);
        }

        @Override
        public InputStream openInputStream(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            return this.getBlob().openInputStream(null, options, opContext);
        }

        public OutputStream openOutputStream(BlobRequestOptions options, OperationContext opContext) throws StorageException {
            return ((CloudBlockBlob)this.getBlob()).openOutputStream(null, options, opContext);
        }

        public void upload(InputStream sourceStream, OperationContext opContext) throws StorageException, IOException {
            this.getBlob().upload(sourceStream, 0L, null, null, opContext);
        }

        @Override
        public CloudBlobContainer getContainer() throws URISyntaxException, StorageException {
            return this.getBlob().getContainer();
        }

        @Override
        public CloudBlobDirectory getParent() throws URISyntaxException, StorageException {
            return this.getBlob().getParent();
        }

        @Override
        public void uploadMetadata(OperationContext opContext) throws StorageException {
            this.getBlob().uploadMetadata(null, null, opContext);
        }

        @Override
        public void uploadProperties(OperationContext opContext, SelfRenewingLease lease) throws StorageException {
            this.getBlob().uploadProperties(this.getLeaseCondition(lease), null, opContext);
        }

        @Override
        public void setStreamMinimumReadSizeInBytes(int minimumReadSizeBytes) {
            this.getBlob().setStreamMinimumReadSizeInBytes(minimumReadSizeBytes);
        }

        @Override
        public void setWriteBlockSizeInBytes(int writeBlockSizeBytes) {
            this.getBlob().setStreamWriteSizeInBytes(writeBlockSizeBytes);
        }

        @Override
        public StorageUri getStorageUri() {
            return this.getBlob().getStorageUri();
        }

        @Override
        public CopyState getCopyState() {
            return this.getBlob().getCopyState();
        }

        @Override
        public void startCopyFromBlob(URI source, BlobRequestOptions options, OperationContext opContext) throws StorageException, URISyntaxException {
            this.getBlob().startCopyFromBlob(source, null, null, options, opContext);
        }

        @Override
        public void downloadRange(long offset, long length, OutputStream outStream, BlobRequestOptions options, OperationContext opContext) throws StorageException, IOException {
            this.getBlob().downloadRange(offset, length, outStream, null, options, opContext);
        }

        @Override
        public SelfRenewingLease acquireLease() throws StorageException {
            return new SelfRenewingLease(this);
        }
    }

    @InterfaceAudience.Private
    static class CloudBlobContainerWrapperImpl
    extends StorageInterface.CloudBlobContainerWrapper {
        private final CloudBlobContainer container;

        public CloudBlobContainerWrapperImpl(CloudBlobContainer container) {
            this.container = container;
        }

        @Override
        public String getName() {
            return this.container.getName();
        }

        @Override
        public boolean exists(OperationContext opContext) throws StorageException {
            return this.container.exists(AccessCondition.generateEmptyCondition(), null, opContext);
        }

        @Override
        public void create(OperationContext opContext) throws StorageException {
            this.container.create(null, opContext);
        }

        @Override
        public HashMap<String, String> getMetadata() {
            return this.container.getMetadata();
        }

        @Override
        public void setMetadata(HashMap<String, String> metadata) {
            this.container.setMetadata(metadata);
        }

        @Override
        public void downloadAttributes(OperationContext opContext) throws StorageException {
            this.container.downloadAttributes(AccessCondition.generateEmptyCondition(), null, opContext);
        }

        @Override
        public void uploadMetadata(OperationContext opContext) throws StorageException {
            this.container.uploadMetadata(AccessCondition.generateEmptyCondition(), null, opContext);
        }

        @Override
        public StorageInterface.CloudBlobDirectoryWrapper getDirectoryReference(String relativePath) throws URISyntaxException, StorageException {
            CloudBlobDirectory dir = this.container.getDirectoryReference(relativePath);
            return new CloudBlobDirectoryWrapperImpl(dir);
        }

        @Override
        public StorageInterface.CloudBlobWrapper getBlockBlobReference(String relativePath) throws URISyntaxException, StorageException {
            return new CloudBlockBlobWrapperImpl(this.container.getBlockBlobReference(relativePath));
        }

        @Override
        public StorageInterface.CloudBlobWrapper getPageBlobReference(String relativePath) throws URISyntaxException, StorageException {
            return new CloudPageBlobWrapperImpl(this.container.getPageBlobReference(relativePath));
        }
    }

    @InterfaceAudience.Private
    static class CloudBlobDirectoryWrapperImpl
    extends StorageInterface.CloudBlobDirectoryWrapper {
        private final CloudBlobDirectory directory;

        public CloudBlobDirectoryWrapperImpl(CloudBlobDirectory directory) {
            this.directory = directory;
        }

        @Override
        public URI getUri() {
            return this.directory.getUri();
        }

        @Override
        public Iterable<ListBlobItem> listBlobs(String prefix, boolean useFlatBlobListing, EnumSet<BlobListingDetails> listingDetails, BlobRequestOptions options, OperationContext opContext) throws URISyntaxException, StorageException {
            return WrappingIterator.wrap(this.directory.listBlobs(prefix, useFlatBlobListing, listingDetails, options, opContext));
        }

        @Override
        public CloudBlobContainer getContainer() throws URISyntaxException, StorageException {
            return this.directory.getContainer();
        }

        @Override
        public CloudBlobDirectory getParent() throws URISyntaxException, StorageException {
            return this.directory.getParent();
        }

        @Override
        public StorageUri getStorageUri() {
            return this.directory.getStorageUri();
        }
    }

    private static class WrappingIterator
    implements Iterator<ListBlobItem> {
        private final Iterator<ListBlobItem> present;

        public WrappingIterator(Iterator<ListBlobItem> present) {
            this.present = present;
        }

        public static Iterable<ListBlobItem> wrap(final Iterable<ListBlobItem> present) {
            return new Iterable<ListBlobItem>(){

                @Override
                public Iterator<ListBlobItem> iterator() {
                    return new WrappingIterator(present.iterator());
                }
            };
        }

        @Override
        public boolean hasNext() {
            return this.present.hasNext();
        }

        @Override
        public ListBlobItem next() {
            ListBlobItem unwrapped = this.present.next();
            if (unwrapped instanceof CloudBlobDirectory) {
                return new CloudBlobDirectoryWrapperImpl((CloudBlobDirectory)unwrapped);
            }
            if (unwrapped instanceof CloudBlockBlob) {
                return new CloudBlockBlobWrapperImpl((CloudBlockBlob)unwrapped);
            }
            if (unwrapped instanceof CloudPageBlob) {
                return new CloudPageBlobWrapperImpl((CloudPageBlob)unwrapped);
            }
            return unwrapped;
        }

        @Override
        public void remove() {
            this.present.remove();
        }
    }
}

