/*
 * Decompiled with CFR 0.152.
 */
package org.apache.htrace.fasterxml.jackson.databind.ser.std;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import org.apache.htrace.fasterxml.jackson.core.JsonGenerationException;
import org.apache.htrace.fasterxml.jackson.core.JsonGenerator;
import org.apache.htrace.fasterxml.jackson.databind.SerializerProvider;
import org.apache.htrace.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import org.apache.htrace.fasterxml.jackson.databind.ser.std.DateTimeSerializerBase;

@JacksonStdImpl
public class DateSerializer
extends DateTimeSerializerBase<Date> {
    public static final DateSerializer instance = new DateSerializer();

    public DateSerializer() {
        this(null, null);
    }

    public DateSerializer(Boolean useTimestamp, DateFormat customFormat) {
        super(Date.class, useTimestamp, customFormat);
    }

    public DateSerializer withFormat(Boolean timestamp, DateFormat customFormat) {
        return new DateSerializer(timestamp, customFormat);
    }

    @Override
    protected long _timestamp(Date value) {
        return value == null ? 0L : value.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(Date value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._asTimestamp(provider)) {
            jgen.writeNumber(this._timestamp(value));
        } else if (this._customFormat != null) {
            DateFormat dateFormat = this._customFormat;
            synchronized (dateFormat) {
                jgen.writeString(this._customFormat.format(value));
            }
        } else {
            provider.defaultSerializeDateValue(value, jgen);
        }
    }
}

