/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Footer;
import com.facebook.presto.orc.metadata.Metadata;
import com.facebook.presto.orc.metadata.MetadataReader;
import com.facebook.presto.orc.metadata.OrcMetadataReader;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.metadata.PostScript;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.StripeFooter;
import com.facebook.presto.orc.metadata.StripeInformation;
import com.facebook.presto.orc.metadata.statistics.BinaryStatistics;
import com.facebook.presto.orc.metadata.statistics.BooleanStatistics;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.DoubleStatistics;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import com.facebook.presto.orc.metadata.statistics.StripeStatistics;
import com.facebook.presto.orc.proto.DwrfProto;
import com.facebook.presto.orc.protobuf.CodedInputStream;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DwrfMetadataReader
implements MetadataReader {
    @Override
    public PostScript readPostScript(byte[] data, int offset, int length) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((byte[])data, (int)offset, (int)length);
        DwrfProto.PostScript postScript = DwrfProto.PostScript.parseFrom((CodedInputStream)input);
        PostScript.HiveWriterVersion writerVersion = postScript.hasWriterVersion() && postScript.getWriterVersion() > 0 ? PostScript.HiveWriterVersion.ORC_HIVE_8732 : PostScript.HiveWriterVersion.ORIGINAL;
        return new PostScript((List<Integer>)ImmutableList.of(), postScript.getFooterLength(), 0L, DwrfMetadataReader.toCompression(postScript.getCompression()), postScript.getCompressionBlockSize(), writerVersion);
    }

    @Override
    public Metadata readMetadata(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws IOException {
        return new Metadata((List<StripeStatistics>)ImmutableList.of());
    }

    @Override
    public Footer readFooter(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        DwrfProto.Footer footer = DwrfProto.Footer.parseFrom((CodedInputStream)input);
        ImmutableList fileStats = ImmutableList.of();
        return new Footer(footer.getNumberOfRows(), footer.getRowIndexStride(), DwrfMetadataReader.toStripeInformation(footer.getStripesList()), DwrfMetadataReader.toType(footer.getTypesList()), (List<ColumnStatistics>)fileStats, this.toUserMetadata(footer.getMetadataList()));
    }

    private static List<StripeInformation> toStripeInformation(List<DwrfProto.StripeInformation> types) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(types, DwrfMetadataReader::toStripeInformation));
    }

    private static StripeInformation toStripeInformation(DwrfProto.StripeInformation stripeInformation) {
        return new StripeInformation(Math.toIntExact(stripeInformation.getNumberOfRows()), stripeInformation.getOffset(), stripeInformation.getIndexLength(), stripeInformation.getDataLength(), stripeInformation.getFooterLength());
    }

    @Override
    public StripeFooter readStripeFooter(List<OrcType> types, InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        DwrfProto.StripeFooter stripeFooter = DwrfProto.StripeFooter.parseFrom((CodedInputStream)input);
        return new StripeFooter(DwrfMetadataReader.toStream(stripeFooter.getStreamsList()), DwrfMetadataReader.toColumnEncoding(types, stripeFooter.getColumnsList()));
    }

    private static Stream toStream(DwrfProto.Stream stream) {
        return new Stream(stream.getColumn(), DwrfMetadataReader.toStreamKind(stream.getKind()), Math.toIntExact(stream.getLength()), stream.getUseVInts());
    }

    private static List<Stream> toStream(List<DwrfProto.Stream> streams) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(streams, DwrfMetadataReader::toStream));
    }

    private static ColumnEncoding toColumnEncoding(OrcType.OrcTypeKind type, DwrfProto.ColumnEncoding columnEncoding) {
        return new ColumnEncoding(DwrfMetadataReader.toColumnEncodingKind(type, columnEncoding.getKind()), columnEncoding.getDictionarySize());
    }

    private static List<ColumnEncoding> toColumnEncoding(List<OrcType> types, List<DwrfProto.ColumnEncoding> columnEncodings) {
        Preconditions.checkArgument((types.size() == columnEncodings.size() ? 1 : 0) != 0);
        ImmutableList.Builder encodings = ImmutableList.builder();
        for (int i = 0; i < types.size(); ++i) {
            OrcType type = types.get(i);
            encodings.add((Object)DwrfMetadataReader.toColumnEncoding(type.getOrcTypeKind(), columnEncodings.get(i)));
        }
        return encodings.build();
    }

    @Override
    public List<RowGroupIndex> readRowIndexes(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws IOException {
        CodedInputStream input = CodedInputStream.newInstance((InputStream)inputStream);
        DwrfProto.RowIndex rowIndex = DwrfProto.RowIndex.parseFrom((CodedInputStream)input);
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)rowIndex.getEntryList(), rowIndexEntry -> DwrfMetadataReader.toRowGroupIndex(hiveWriterVersion, rowIndexEntry)));
    }

    @Override
    public List<HiveBloomFilter> readBloomFilterIndexes(InputStream inputStream) throws IOException {
        return ImmutableList.of();
    }

    private static RowGroupIndex toRowGroupIndex(PostScript.HiveWriterVersion hiveWriterVersion, DwrfProto.RowIndexEntry rowIndexEntry) {
        List positionsList = rowIndexEntry.getPositionsList();
        ImmutableList.Builder positions = ImmutableList.builder();
        for (int index = 0; index < positionsList.size(); ++index) {
            long longPosition = (Long)positionsList.get(index);
            int intPosition = (int)longPosition;
            Preconditions.checkState(((long)intPosition == longPosition ? 1 : 0) != 0, (String)"Expected checkpoint position %s, to be an integer", (int)index);
            positions.add((Object)intPosition);
        }
        return new RowGroupIndex((List<Integer>)positions.build(), DwrfMetadataReader.toColumnStatistics(hiveWriterVersion, rowIndexEntry.getStatistics(), true));
    }

    private static List<ColumnStatistics> toColumnStatistics(PostScript.HiveWriterVersion hiveWriterVersion, List<DwrfProto.ColumnStatistics> columnStatistics, boolean isRowGroup) {
        if (columnStatistics == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform(columnStatistics, statistics -> DwrfMetadataReader.toColumnStatistics(hiveWriterVersion, statistics, isRowGroup)));
    }

    private Map<String, Slice> toUserMetadata(List<DwrfProto.UserMetadataItem> metadataList) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (DwrfProto.UserMetadataItem item : metadataList) {
            mapBuilder.put((Object)item.getName(), (Object)OrcMetadataReader.byteStringToSlice(item.getValue()));
        }
        return mapBuilder.build();
    }

    private static ColumnStatistics toColumnStatistics(PostScript.HiveWriterVersion hiveWriterVersion, DwrfProto.ColumnStatistics statistics, boolean isRowGroup) {
        long minAverageValueBytes;
        if (statistics.hasBucketStatistics()) {
            minAverageValueBytes = 2L;
        } else if (statistics.hasIntStatistics()) {
            minAverageValueBytes = 9L;
        } else if (statistics.hasDoubleStatistics()) {
            minAverageValueBytes = 9L;
        } else if (statistics.hasStringStatistics()) {
            minAverageValueBytes = 5L;
            if (statistics.hasNumberOfValues() && statistics.getNumberOfValues() > 0L) {
                minAverageValueBytes += statistics.getStringStatistics().getSum() / statistics.getNumberOfValues();
            }
        } else if (statistics.hasBinaryStatistics()) {
            minAverageValueBytes = 5L;
            if (statistics.hasNumberOfValues() && statistics.getNumberOfValues() > 0L) {
                minAverageValueBytes += statistics.getBinaryStatistics().getSum() / statistics.getNumberOfValues();
            }
        } else {
            minAverageValueBytes = 0L;
        }
        return new ColumnStatistics(statistics.getNumberOfValues(), minAverageValueBytes, DwrfMetadataReader.toBooleanStatistics(statistics.getBucketStatistics()), DwrfMetadataReader.toIntegerStatistics(statistics.getIntStatistics()), DwrfMetadataReader.toDoubleStatistics(statistics.getDoubleStatistics()), DwrfMetadataReader.toStringStatistics(hiveWriterVersion, statistics.getStringStatistics(), isRowGroup), null, null, DwrfMetadataReader.toBinaryStatistics(statistics.getBinaryStatistics()), null);
    }

    private static BooleanStatistics toBooleanStatistics(DwrfProto.BucketStatistics bucketStatistics) {
        if (bucketStatistics.getCountCount() == 0) {
            return null;
        }
        return new BooleanStatistics(bucketStatistics.getCount(0));
    }

    private static IntegerStatistics toIntegerStatistics(DwrfProto.IntegerStatistics integerStatistics) {
        if (!integerStatistics.hasMinimum() && !integerStatistics.hasMaximum()) {
            return null;
        }
        return new IntegerStatistics(integerStatistics.hasMinimum() ? Long.valueOf(integerStatistics.getMinimum()) : null, integerStatistics.hasMaximum() ? Long.valueOf(integerStatistics.getMaximum()) : null);
    }

    private static DoubleStatistics toDoubleStatistics(DwrfProto.DoubleStatistics doubleStatistics) {
        if (!doubleStatistics.hasMinimum() && !doubleStatistics.hasMaximum()) {
            return null;
        }
        if (doubleStatistics.hasMinimum() && Double.isNaN(doubleStatistics.getMinimum()) || doubleStatistics.hasMaximum() && Double.isNaN(doubleStatistics.getMaximum()) || doubleStatistics.hasSum() && Double.isNaN(doubleStatistics.getSum())) {
            return null;
        }
        return new DoubleStatistics(doubleStatistics.hasMinimum() ? Double.valueOf(doubleStatistics.getMinimum()) : null, doubleStatistics.hasMaximum() ? Double.valueOf(doubleStatistics.getMaximum()) : null);
    }

    @VisibleForTesting
    static StringStatistics toStringStatistics(PostScript.HiveWriterVersion hiveWriterVersion, DwrfProto.StringStatistics stringStatistics, boolean isRowGroup) {
        if (hiveWriterVersion == PostScript.HiveWriterVersion.ORIGINAL && !isRowGroup) {
            return null;
        }
        if (!stringStatistics.hasMinimum() && !stringStatistics.hasMaximum()) {
            return null;
        }
        Slice maximum = stringStatistics.hasMaximum() ? OrcMetadataReader.maxStringTruncateToValidRange(OrcMetadataReader.byteStringToSlice(stringStatistics.getMaximumBytes()), hiveWriterVersion) : null;
        Slice minimum = stringStatistics.hasMinimum() ? OrcMetadataReader.minStringTruncateToValidRange(OrcMetadataReader.byteStringToSlice(stringStatistics.getMinimumBytes()), hiveWriterVersion) : null;
        long sum = stringStatistics.hasSum() ? stringStatistics.getSum() : 0L;
        return new StringStatistics(minimum, maximum, sum);
    }

    private static BinaryStatistics toBinaryStatistics(DwrfProto.BinaryStatistics binaryStatistics) {
        if (!binaryStatistics.hasSum()) {
            return null;
        }
        return new BinaryStatistics(binaryStatistics.getSum());
    }

    private static OrcType toType(DwrfProto.Type type) {
        return new OrcType(DwrfMetadataReader.toTypeKind(type.getKind()), type.getSubtypesList(), (List<String>)type.getFieldNamesList(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static List<OrcType> toType(List<DwrfProto.Type> types) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(types, DwrfMetadataReader::toType));
    }

    private static OrcType.OrcTypeKind toTypeKind(DwrfProto.Type.Kind kind) {
        switch (kind) {
            case BOOLEAN: {
                return OrcType.OrcTypeKind.BOOLEAN;
            }
            case BYTE: {
                return OrcType.OrcTypeKind.BYTE;
            }
            case SHORT: {
                return OrcType.OrcTypeKind.SHORT;
            }
            case INT: {
                return OrcType.OrcTypeKind.INT;
            }
            case LONG: {
                return OrcType.OrcTypeKind.LONG;
            }
            case FLOAT: {
                return OrcType.OrcTypeKind.FLOAT;
            }
            case DOUBLE: {
                return OrcType.OrcTypeKind.DOUBLE;
            }
            case STRING: {
                return OrcType.OrcTypeKind.STRING;
            }
            case BINARY: {
                return OrcType.OrcTypeKind.BINARY;
            }
            case TIMESTAMP: {
                return OrcType.OrcTypeKind.TIMESTAMP;
            }
            case LIST: {
                return OrcType.OrcTypeKind.LIST;
            }
            case MAP: {
                return OrcType.OrcTypeKind.MAP;
            }
            case STRUCT: {
                return OrcType.OrcTypeKind.STRUCT;
            }
            case UNION: {
                return OrcType.OrcTypeKind.UNION;
            }
        }
        throw new IllegalArgumentException(kind + " data type not implemented yet");
    }

    private static Stream.StreamKind toStreamKind(DwrfProto.Stream.Kind kind) {
        switch (kind) {
            case PRESENT: {
                return Stream.StreamKind.PRESENT;
            }
            case DATA: {
                return Stream.StreamKind.DATA;
            }
            case LENGTH: {
                return Stream.StreamKind.LENGTH;
            }
            case DICTIONARY_DATA: {
                return Stream.StreamKind.DICTIONARY_DATA;
            }
            case DICTIONARY_COUNT: {
                return Stream.StreamKind.DICTIONARY_COUNT;
            }
            case NANO_DATA: {
                return Stream.StreamKind.SECONDARY;
            }
            case ROW_INDEX: {
                return Stream.StreamKind.ROW_INDEX;
            }
            case IN_DICTIONARY: {
                return Stream.StreamKind.IN_DICTIONARY;
            }
            case STRIDE_DICTIONARY: {
                return Stream.StreamKind.ROW_GROUP_DICTIONARY;
            }
            case STRIDE_DICTIONARY_LENGTH: {
                return Stream.StreamKind.ROW_GROUP_DICTIONARY_LENGTH;
            }
        }
        throw new IllegalArgumentException(kind + " stream type not implemented yet");
    }

    private static ColumnEncoding.ColumnEncodingKind toColumnEncodingKind(OrcType.OrcTypeKind type, DwrfProto.ColumnEncoding.Kind kind) {
        switch (kind) {
            case DIRECT: {
                if (type == OrcType.OrcTypeKind.SHORT || type == OrcType.OrcTypeKind.INT || type == OrcType.OrcTypeKind.LONG) {
                    return ColumnEncoding.ColumnEncodingKind.DWRF_DIRECT;
                }
                return ColumnEncoding.ColumnEncodingKind.DIRECT;
            }
            case DICTIONARY: {
                return ColumnEncoding.ColumnEncodingKind.DICTIONARY;
            }
        }
        throw new IllegalArgumentException(kind + " stream encoding not implemented yet");
    }

    private static CompressionKind toCompression(DwrfProto.CompressionKind compression) {
        switch (compression) {
            case NONE: {
                return CompressionKind.NONE;
            }
            case ZLIB: {
                return CompressionKind.ZLIB;
            }
            case SNAPPY: {
                return CompressionKind.SNAPPY;
            }
            case ZSTD: {
                return CompressionKind.ZSTD;
            }
        }
        throw new IllegalArgumentException(compression + " compression not implemented yet");
    }
}

