/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.OrcCorruptionException;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.SliceStreamReader;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.ByteArrayInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.orc.stream.RowGroupDictionaryLengthInputStream;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.VariableWidthBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SliceDictionaryStreamReader
implements StreamReader {
    private static final byte[] EMPTY_DICTIONARY_DATA = new byte[0];
    private static final int[] EMPTY_DICTIONARY_OFFSETS = new int[2];
    private final StreamDescriptor streamDescriptor;
    private int readOffset;
    private int nextBatchSize;
    @Nonnull
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private boolean[] isNullVector = new boolean[0];
    @Nonnull
    private InputStreamSource<ByteArrayInputStream> stripeDictionaryDataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
    private boolean stripeDictionaryOpen;
    private int stripeDictionarySize;
    @Nonnull
    private int[] stripeDictionaryLength = new int[0];
    @Nonnull
    private byte[] stripeDictionaryData = EMPTY_DICTIONARY_DATA;
    @Nonnull
    private int[] stripeDictionaryOffsetVector = EMPTY_DICTIONARY_OFFSETS;
    private VariableWidthBlock dictionaryBlock = new VariableWidthBlock(1, Slices.wrappedBuffer((byte[])EMPTY_DICTIONARY_DATA), EMPTY_DICTIONARY_OFFSETS, new boolean[]{true});
    private byte[] currentDictionaryData = EMPTY_DICTIONARY_DATA;
    @Nonnull
    private InputStreamSource<LongInputStream> stripeDictionaryLengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nonnull
    private InputStreamSource<BooleanInputStream> inDictionaryStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream inDictionaryStream;
    private boolean[] inDictionary = new boolean[0];
    @Nonnull
    private InputStreamSource<ByteArrayInputStream> rowGroupDictionaryDataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
    @Nonnull
    private InputStreamSource<RowGroupDictionaryLengthInputStream> rowGroupDictionaryLengthStreamSource = MissingInputStreamSource.missingStreamSource(RowGroupDictionaryLengthInputStream.class);
    @Nonnull
    private int[] rowGroupDictionaryLength = new int[0];
    @Nonnull
    private InputStreamSource<LongInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream dataStream;
    private boolean rowGroupOpen;

    public SliceDictionaryStreamReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        if (!this.rowGroupOpen) {
            this.openRowGroup(type);
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                }
                if (this.inDictionaryStream != null) {
                    this.inDictionaryStream.skip(this.readOffset);
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        if (this.isNullVector.length < this.nextBatchSize) {
            this.isNullVector = new boolean[this.nextBatchSize];
        }
        int[] dataVector = new int[this.nextBatchSize];
        if (this.presentStream == null) {
            if (this.dataStream == null) {
                throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
            }
            Arrays.fill(this.isNullVector, false);
            this.dataStream.nextIntVector(this.nextBatchSize, dataVector);
        } else {
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, this.isNullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Value is not null but data stream is not present");
                }
                this.dataStream.nextIntVector(this.nextBatchSize, dataVector, this.isNullVector);
            }
        }
        if (this.inDictionary.length < this.nextBatchSize) {
            this.inDictionary = new boolean[this.nextBatchSize];
        }
        if (this.inDictionaryStream == null) {
            Arrays.fill(this.inDictionary, true);
        } else {
            this.inDictionaryStream.getSetBits(this.nextBatchSize, this.inDictionary, this.isNullVector);
        }
        for (int i = 0; i < this.nextBatchSize; ++i) {
            if (this.isNullVector[i]) {
                dataVector[i] = this.dictionaryBlock.getPositionCount() - 1;
                continue;
            }
            if (this.inDictionary[i]) continue;
            int n = i;
            dataVector[n] = dataVector[n] + this.stripeDictionarySize;
        }
        DictionaryBlock block = new DictionaryBlock(this.nextBatchSize, (Block)this.dictionaryBlock, dataVector);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private void setDictionaryBlockData(byte[] dictionaryData, int[] dictionaryOffsets, int positionCount) {
        Verify.verify((positionCount > 0 ? 1 : 0) != 0);
        if (this.currentDictionaryData != dictionaryData) {
            boolean[] isNullVector = new boolean[positionCount];
            isNullVector[positionCount - 1] = true;
            dictionaryOffsets[positionCount] = dictionaryOffsets[positionCount - 1];
            this.dictionaryBlock = new VariableWidthBlock(positionCount, Slices.wrappedBuffer((byte[])dictionaryData), dictionaryOffsets, isNullVector);
            this.currentDictionaryData = dictionaryData;
        }
    }

    private void openRowGroup(Type type) throws IOException {
        if (!this.stripeDictionaryOpen) {
            if (this.stripeDictionarySize > 0) {
                LongInputStream lengthStream;
                if (this.stripeDictionaryLength.length < this.stripeDictionarySize) {
                    this.stripeDictionaryLength = new int[this.stripeDictionarySize];
                }
                if ((lengthStream = this.stripeDictionaryLengthStreamSource.openStream()) == null) {
                    throw new OrcCorruptionException(this.streamDescriptor.getOrcDataSourceId(), "Dictionary is not empty but dictionary length stream is not present");
                }
                lengthStream.nextIntVector(this.stripeDictionarySize, this.stripeDictionaryLength);
                long dataLength = 0L;
                for (int i = 0; i < this.stripeDictionarySize; ++i) {
                    dataLength += (long)this.stripeDictionaryLength[i];
                }
                this.stripeDictionaryData = new byte[Math.toIntExact(dataLength)];
                this.stripeDictionaryOffsetVector = new int[this.stripeDictionarySize + 2];
                ByteArrayInputStream dictionaryDataStream = this.stripeDictionaryDataStreamSource.openStream();
                SliceDictionaryStreamReader.readDictionary(dictionaryDataStream, this.stripeDictionarySize, this.stripeDictionaryLength, 0, this.stripeDictionaryData, this.stripeDictionaryOffsetVector, type);
            } else {
                this.stripeDictionaryData = EMPTY_DICTIONARY_DATA;
                this.stripeDictionaryOffsetVector = EMPTY_DICTIONARY_OFFSETS;
            }
        }
        this.stripeDictionaryOpen = true;
        RowGroupDictionaryLengthInputStream dictionaryLengthStream = this.rowGroupDictionaryLengthStreamSource.openStream();
        if (dictionaryLengthStream != null) {
            int rowGroupDictionarySize = dictionaryLengthStream.getEntryCount();
            if (this.rowGroupDictionaryLength.length < rowGroupDictionarySize) {
                this.rowGroupDictionaryLength = new int[rowGroupDictionarySize];
            }
            dictionaryLengthStream.nextIntVector(rowGroupDictionarySize, this.rowGroupDictionaryLength);
            long dataLength = 0L;
            for (int i = 0; i < rowGroupDictionarySize; ++i) {
                dataLength += (long)this.rowGroupDictionaryLength[i];
            }
            byte[] rowGroupDictionaryData = Arrays.copyOf(this.stripeDictionaryData, this.stripeDictionaryOffsetVector[this.stripeDictionarySize] + Math.toIntExact(dataLength));
            int[] rowGroupDictionaryOffsetVector = Arrays.copyOf(this.stripeDictionaryOffsetVector, this.stripeDictionarySize + rowGroupDictionarySize + 2);
            ByteArrayInputStream dictionaryDataStream = this.rowGroupDictionaryDataStreamSource.openStream();
            SliceDictionaryStreamReader.readDictionary(dictionaryDataStream, rowGroupDictionarySize, this.rowGroupDictionaryLength, this.stripeDictionarySize, rowGroupDictionaryData, rowGroupDictionaryOffsetVector, type);
            this.setDictionaryBlockData(rowGroupDictionaryData, rowGroupDictionaryOffsetVector, this.stripeDictionarySize + rowGroupDictionarySize + 1);
        } else {
            this.setDictionaryBlockData(this.stripeDictionaryData, this.stripeDictionaryOffsetVector, this.stripeDictionarySize + 1);
        }
        this.presentStream = this.presentStreamSource.openStream();
        this.inDictionaryStream = this.inDictionaryStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    private static void readDictionary(@Nullable ByteArrayInputStream dictionaryDataStream, int dictionarySize, int[] dictionaryLengthVector, int offsetVectorOffset, byte[] data, int[] offsetVector, Type type) throws IOException {
        Slice slice = Slices.wrappedBuffer((byte[])data);
        if (offsetVectorOffset == 0) {
            offsetVector[0] = 0;
        }
        for (int i = 0; i < dictionarySize; ++i) {
            int truncatedLength;
            int offsetIndex = offsetVectorOffset + i;
            int offset = offsetVector[offsetIndex];
            int length = dictionaryLengthVector[i];
            if (length > 0) {
                dictionaryDataStream.next(data, offset, offset + length);
                truncatedLength = SliceStreamReader.computeTruncatedLength(slice, offset, length, type);
                Verify.verify((truncatedLength >= 0 ? 1 : 0) != 0);
            } else {
                truncatedLength = 0;
            }
            offsetVector[offsetIndex + 1] = offsetVector[offsetIndex] + truncatedLength;
        }
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        this.stripeDictionaryDataStreamSource = dictionaryStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DICTIONARY_DATA, ByteArrayInputStream.class);
        this.stripeDictionaryLengthStreamSource = dictionaryStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.stripeDictionarySize = encoding.get(this.streamDescriptor.getStreamId()).getDictionarySize();
        this.stripeDictionaryOpen = false;
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.inDictionaryStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.rowGroupDictionaryLengthStreamSource = MissingInputStreamSource.missingStreamSource(RowGroupDictionaryLengthInputStream.class);
        this.rowGroupDictionaryDataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.DATA, LongInputStream.class);
        this.inDictionaryStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.IN_DICTIONARY, BooleanInputStream.class);
        this.rowGroupDictionaryLengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.ROW_GROUP_DICTIONARY_LENGTH, RowGroupDictionaryLengthInputStream.class);
        this.rowGroupDictionaryDataStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.ROW_GROUP_DICTIONARY, ByteArrayInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.inDictionaryStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }
}

