/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.reader.SliceDictionaryStreamReader;
import com.facebook.presto.orc.reader.SliceDirectStreamReader;
import com.facebook.presto.orc.reader.StreamReader;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.CharType;
import com.facebook.presto.spi.type.Chars;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.spi.type.Varchars;
import com.google.common.base.MoreObjects;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class SliceStreamReader
implements StreamReader {
    private final StreamDescriptor streamDescriptor;
    private final SliceDirectStreamReader directReader;
    private final SliceDictionaryStreamReader dictionaryReader;
    private StreamReader currentReader;

    public SliceStreamReader(StreamDescriptor streamDescriptor) {
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "stream is null");
        this.directReader = new SliceDirectStreamReader(streamDescriptor);
        this.dictionaryReader = new SliceDictionaryStreamReader(streamDescriptor);
    }

    @Override
    public Block readBlock(Type type) throws IOException {
        return this.currentReader.readBlock(type);
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.currentReader.prepareNextRead(batchSize);
    }

    @Override
    public void startStripe(InputStreamSources dictionaryStreamSources, List<ColumnEncoding> encoding) throws IOException {
        ColumnEncoding.ColumnEncodingKind columnEncodingKind = encoding.get(this.streamDescriptor.getStreamId()).getColumnEncodingKind();
        if (columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DIRECT || columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DIRECT_V2 || columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DWRF_DIRECT) {
            this.currentReader = this.directReader;
        } else if (columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DICTIONARY || columnEncodingKind == ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2) {
            this.currentReader = this.dictionaryReader;
        } else {
            throw new IllegalArgumentException("Unsupported encoding " + (Object)((Object)columnEncodingKind));
        }
        this.currentReader.startStripe(dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.currentReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    public static int computeTruncatedLength(Slice slice, int offset, int length, Type type) {
        int truncatedLength = length;
        if (Varchars.isVarcharType((Type)type)) {
            VarcharType varcharType = (VarcharType)type;
            int codePointCount = varcharType.isUnbounded() ? length : varcharType.getLengthSafe();
            truncatedLength = Varchars.byteCount((Slice)slice, (int)offset, (int)length, (int)codePointCount);
        } else if (Chars.isCharType((Type)type)) {
            truncatedLength = Chars.byteCountWithoutTrailingSpace((Slice)slice, (int)offset, (int)length, (int)((CharType)type).getLength());
        }
        return truncatedLength;
    }
}

