/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.OrcOutputBuffer;
import com.facebook.presto.orc.checkpoint.ByteArrayStreamCheckpoint;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.ValueOutputStream;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class ByteArrayOutputStream
implements ValueOutputStream<ByteArrayStreamCheckpoint> {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ByteArrayOutputStream.class).instanceSize();
    private final OrcOutputBuffer buffer;
    private final List<ByteArrayStreamCheckpoint> checkpoints = new ArrayList<ByteArrayStreamCheckpoint>();
    private final Stream.StreamKind streamKind;
    private boolean closed;

    public ByteArrayOutputStream(CompressionKind compression, int bufferSize) {
        this(compression, bufferSize, Stream.StreamKind.DATA);
    }

    public ByteArrayOutputStream(CompressionKind compression, int bufferSize, Stream.StreamKind streamKind) {
        this.buffer = new OrcOutputBuffer(compression, bufferSize);
        this.streamKind = streamKind;
    }

    public void writeSlice(Slice value) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.buffer.writeBytes(value);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void recordCheckpoint() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkpoints.add(new ByteArrayStreamCheckpoint(this.buffer.getCheckpoint()));
    }

    @Override
    public List<ByteArrayStreamCheckpoint> getCheckpoints() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.copyOf(this.checkpoints);
    }

    @Override
    public Optional<Stream> writeDataStreams(int column, SliceOutput outputStream) {
        Preconditions.checkState((boolean)this.closed);
        int length = this.buffer.writeDataTo(outputStream);
        return Optional.of(new Stream(column, this.streamKind, length, false));
    }

    @Override
    public long getBufferedBytes() {
        return this.buffer.size();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.buffer.getRetainedSize();
    }

    @Override
    public void reset() {
        this.closed = false;
        this.buffer.reset();
        this.checkpoints.clear();
    }
}

