/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.metadata.Stream;
import io.airlift.slice.SliceOutput;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;

public final class OutputDataStream
implements Comparable<OutputDataStream> {
    private final Function<SliceOutput, Optional<Stream>> writer;
    private final long sizeInBytes;

    public OutputDataStream(Function<SliceOutput, Optional<Stream>> writer, long sizeInBytes) {
        this.writer = Objects.requireNonNull(writer, "writer is null");
        this.sizeInBytes = sizeInBytes;
    }

    @Override
    public int compareTo(@Nonnull OutputDataStream otherStream) {
        return Long.compare(this.sizeInBytes, otherStream.sizeInBytes);
    }

    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    public Optional<Stream> writeData(SliceOutput sliceOutput) {
        return this.writer.apply(sliceOutput);
    }
}

