/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.LongValueStatisticsBuilder;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.LongOutputStreamDwrf;
import com.facebook.presto.orc.stream.LongOutputStreamV2;
import com.facebook.presto.orc.stream.OutputDataStream;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SliceOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.openjdk.jol.info.ClassLayout;

public class LongColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongColumnWriter.class).instanceSize();
    private final int column;
    private final Type type;
    private final boolean compressed;
    private final ColumnEncoding columnEncoding;
    private final LongOutputStream dataStream;
    private final PresentOutputStream presentStream;
    private final List<ColumnStatistics> rowGroupColumnStatistics = new ArrayList<ColumnStatistics>();
    private final Supplier<LongValueStatisticsBuilder> statisticsBuilderSupplier;
    private LongValueStatisticsBuilder statisticsBuilder;
    private boolean closed;

    public LongColumnWriter(int column, Type type, CompressionKind compression, int bufferSize, boolean isDwrf, Supplier<LongValueStatisticsBuilder> statisticsBuilderSupplier) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"column is negative");
        this.column = column;
        this.type = Objects.requireNonNull(type, "type is null");
        this.compressed = Objects.requireNonNull(compression, "compression is null") != CompressionKind.NONE;
        this.columnEncoding = new ColumnEncoding(isDwrf ? ColumnEncoding.ColumnEncodingKind.DIRECT : ColumnEncoding.ColumnEncodingKind.DIRECT_V2, 0);
        this.dataStream = isDwrf ? new LongOutputStreamDwrf(compression, bufferSize, true, Stream.StreamKind.DATA) : new LongOutputStreamV2(compression, bufferSize, true, Stream.StreamKind.DATA);
        this.presentStream = new PresentOutputStream(compression, bufferSize);
        this.statisticsBuilderSupplier = Objects.requireNonNull(statisticsBuilderSupplier, "statisticsBuilderSupplier is null");
        this.statisticsBuilder = statisticsBuilderSupplier.get();
    }

    @Override
    public Map<Integer, ColumnEncoding> getColumnEncodings() {
        return ImmutableMap.of((Object)this.column, (Object)this.columnEncoding);
    }

    @Override
    public void beginRowGroup() {
        this.presentStream.recordCheckpoint();
        this.dataStream.recordCheckpoint();
    }

    @Override
    public void writeBlock(Block block) {
        int position;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        for (position = 0; position < block.getPositionCount(); ++position) {
            this.presentStream.writeBoolean(!block.isNull(position));
        }
        for (position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            long value = this.type.getLong(block, position);
            this.dataStream.writeLong(value);
            this.statisticsBuilder.addValue(value);
        }
    }

    @Override
    public Map<Integer, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        ColumnStatistics statistics = this.statisticsBuilder.buildColumnStatistics();
        this.rowGroupColumnStatistics.add(statistics);
        this.statisticsBuilder = this.statisticsBuilderSupplier.get();
        return ImmutableMap.of((Object)this.column, (Object)statistics);
    }

    @Override
    public void close() {
        this.closed = true;
        this.dataStream.close();
        this.presentStream.close();
    }

    @Override
    public Map<Integer, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableMap.of((Object)this.column, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroupColumnStatistics));
    }

    @Override
    public List<Stream> writeIndexStreams(SliceOutput outputStream, MetadataWriter metadataWriter) throws IOException {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder rowGroupIndexes = ImmutableList.builder();
        List dataCheckpoints = this.dataStream.getCheckpoints();
        Optional<List<BooleanStreamCheckpoint>> presentCheckpoints = this.presentStream.getCheckpoints();
        int i = 0;
        while (i < this.rowGroupColumnStatistics.size()) {
            int groupId = i++;
            ColumnStatistics columnStatistics = this.rowGroupColumnStatistics.get(groupId);
            LongStreamCheckpoint dataCheckpoint = (LongStreamCheckpoint)dataCheckpoints.get(groupId);
            Optional<BooleanStreamCheckpoint> presentCheckpoint = presentCheckpoints.map(checkpoints -> (BooleanStreamCheckpoint)checkpoints.get(groupId));
            List<Integer> positions = LongColumnWriter.createLongColumnPositionList(this.compressed, dataCheckpoint, presentCheckpoint);
            rowGroupIndexes.add((Object)new RowGroupIndex(positions, columnStatistics));
        }
        int length = metadataWriter.writeRowIndexes(outputStream, (List<RowGroupIndex>)rowGroupIndexes.build());
        return ImmutableList.of((Object)new Stream(this.column, Stream.StreamKind.ROW_INDEX, length, false));
    }

    private static List<Integer> createLongColumnPositionList(boolean compressed, LongStreamCheckpoint dataCheckpoint, Optional<BooleanStreamCheckpoint> presentCheckpoint) {
        ImmutableList.Builder positionList = ImmutableList.builder();
        presentCheckpoint.ifPresent(booleanStreamCheckpoint -> positionList.addAll(booleanStreamCheckpoint.toPositionList(compressed)));
        positionList.addAll(dataCheckpoint.toPositionList(compressed));
        return positionList.build();
    }

    @Override
    public List<OutputDataStream> getOutputDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        outputDataStreams.add((Object)new OutputDataStream(sliceOutput -> this.presentStream.writeDataStreams(this.column, (SliceOutput)sliceOutput), this.presentStream.getBufferedBytes()));
        outputDataStreams.add((Object)new OutputDataStream(sliceOutput -> this.dataStream.writeDataStreams(this.column, (SliceOutput)sliceOutput), this.dataStream.getBufferedBytes()));
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        return this.dataStream.getBufferedBytes() + this.presentStream.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.dataStream.getRetainedBytes() + this.presentStream.getRetainedBytes();
    }

    @Override
    public void reset() {
        this.closed = false;
        this.dataStream.reset();
        this.presentStream.reset();
        this.rowGroupColumnStatistics.clear();
        this.statisticsBuilder = this.statisticsBuilderSupplier.get();
    }
}

