/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.array.IntBigArray;
import com.facebook.presto.orc.DictionaryCompressionOptimizer;
import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StringStatisticsBuilder;
import com.facebook.presto.orc.stream.ByteArrayOutputStream;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.LongOutputStreamV1;
import com.facebook.presto.orc.stream.LongOutputStreamV2;
import com.facebook.presto.orc.stream.OutputDataStream;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.DictionaryBuilder;
import com.facebook.presto.orc.writer.SliceDirectColumnWriter;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openjdk.jol.info.ClassLayout;

public class SliceDictionaryColumnWriter
implements ColumnWriter,
DictionaryCompressionOptimizer.DictionaryColumn {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceDictionaryColumnWriter.class).instanceSize();
    private final int column;
    private final Type type;
    private final CompressionKind compression;
    private final int bufferSize;
    private final boolean isDwrf;
    private final LongOutputStream dataStream;
    private final PresentOutputStream presentStream;
    private final ByteArrayOutputStream dictionaryDataStream;
    private final LongOutputStream dictionaryLengthStream;
    private final DictionaryBuilder dictionary = new DictionaryBuilder(10000);
    private final List<DictionaryRowGroup> rowGroups = new ArrayList<DictionaryRowGroup>();
    private IntBigArray values;
    private int valueCount;
    private StringStatisticsBuilder statisticsBuilder = new StringStatisticsBuilder();
    private long rawBytes;
    private boolean closed;
    private boolean inRowGroup;
    private ColumnEncoding columnEncoding;
    private boolean directEncoded;
    private SliceDirectColumnWriter directColumnWriter;

    public SliceDictionaryColumnWriter(int column, Type type, CompressionKind compression, int bufferSize, boolean isDwrf) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"column is negative");
        this.column = column;
        this.type = Objects.requireNonNull(type, "type is null");
        this.compression = Objects.requireNonNull(compression, "compression is null");
        this.bufferSize = bufferSize;
        this.isDwrf = isDwrf;
        LongOutputStream result = isDwrf ? new LongOutputStreamV1(compression, bufferSize, false, Stream.StreamKind.DATA) : new LongOutputStreamV2(compression, bufferSize, false, Stream.StreamKind.DATA);
        this.dataStream = result;
        this.presentStream = new PresentOutputStream(compression, bufferSize);
        this.dictionaryDataStream = new ByteArrayOutputStream(compression, bufferSize, Stream.StreamKind.DICTIONARY_DATA);
        this.dictionaryLengthStream = LongOutputStream.createLengthOutputStream(compression, bufferSize, isDwrf);
        this.values = new IntBigArray();
    }

    @Override
    public long getRawBytes() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return this.rawBytes;
    }

    @Override
    public int getDictionaryBytes() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return Math.toIntExact(this.dictionary.getSizeInBytes());
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public int getNonNullValueCount() {
        return Math.toIntExact(this.statisticsBuilder.getNonNullValueCount());
    }

    @Override
    public int getDictionaryEntries() {
        return this.dictionary.getEntryCount();
    }

    @Override
    public void convertToDirect() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        if (this.directColumnWriter == null) {
            this.directColumnWriter = new SliceDirectColumnWriter(this.column, this.type, this.compression, this.bufferSize, this.isDwrf, StringStatisticsBuilder::new);
        }
        Block dictionaryValues = this.dictionary.getElementBlock();
        for (DictionaryRowGroup rowGroup : this.rowGroups) {
            this.directColumnWriter.beginRowGroup();
            this.writeDictionaryRowGroup(dictionaryValues, rowGroup.getValueCount(), rowGroup.getDictionaryIndexes());
            this.directColumnWriter.finishRowGroup();
        }
        if (this.inRowGroup) {
            this.directColumnWriter.beginRowGroup();
            this.writeDictionaryRowGroup(dictionaryValues, this.valueCount, this.values);
        } else {
            Preconditions.checkState((this.valueCount == 0 ? 1 : 0) != 0);
        }
        this.rowGroups.clear();
        this.rawBytes = 0L;
        this.valueCount = 0;
        this.statisticsBuilder = new StringStatisticsBuilder();
        this.directEncoded = true;
    }

    private void writeDictionaryRowGroup(Block dictionary, int valueCount, IntBigArray dictionaryIndexes) {
        int positionCount;
        int[][] segments = dictionaryIndexes.getSegments();
        for (int i = 0; valueCount > 0 && i < segments.length; valueCount -= positionCount, ++i) {
            int[] segment = segments[i];
            positionCount = Math.min(valueCount, segment.length);
            DictionaryBlock dictionaryBlock = new DictionaryBlock(positionCount, dictionary, segment);
            this.directColumnWriter.writeBlock((Block)dictionaryBlock);
        }
        Preconditions.checkState((valueCount == 0 ? 1 : 0) != 0);
    }

    @Override
    public Map<Integer, ColumnEncoding> getColumnEncodings() {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.directColumnWriter.getColumnEncodings();
        }
        return ImmutableMap.of((Object)this.column, (Object)this.columnEncoding);
    }

    @Override
    public void beginRowGroup() {
        Preconditions.checkState((!this.inRowGroup ? 1 : 0) != 0);
        this.inRowGroup = true;
        if (this.directEncoded) {
            this.directColumnWriter.beginRowGroup();
        }
    }

    @Override
    public void writeBlock(Block block) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        if (this.directEncoded) {
            this.directColumnWriter.writeBlock(block);
            return;
        }
        this.values.ensureCapacity((long)(this.valueCount + block.getPositionCount()));
        for (int position = 0; position < block.getPositionCount(); ++position) {
            int index = this.dictionary.putIfAbsent(block, position);
            this.values.set((long)this.valueCount, index);
            ++this.valueCount;
            if (block.isNull(position)) continue;
            this.statisticsBuilder.addValue(this.type.getSlice(block, position));
            this.rawBytes += (long)block.getSliceLength(position);
        }
    }

    @Override
    public Map<Integer, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.inRowGroup);
        this.inRowGroup = false;
        if (this.directEncoded) {
            return this.directColumnWriter.finishRowGroup();
        }
        ColumnStatistics statistics = this.statisticsBuilder.buildColumnStatistics();
        this.rowGroups.add(new DictionaryRowGroup(this.values, this.valueCount, statistics));
        this.valueCount = 0;
        this.statisticsBuilder = new StringStatisticsBuilder();
        this.values = new IntBigArray();
        return ImmutableMap.of((Object)this.column, (Object)statistics);
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.inRowGroup ? 1 : 0) != 0);
        this.closed = true;
        if (this.directEncoded) {
            this.directColumnWriter.close();
        } else {
            this.bufferOutputData();
        }
    }

    @Override
    public Map<Integer, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.directColumnWriter.getColumnStripeStatistics();
        }
        return ImmutableMap.of((Object)this.column, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroups.stream().map(DictionaryRowGroup::getColumnStatistics).collect(Collectors.toList())));
    }

    private void bufferOutputData() {
        int[] sortedDictionaryIndexes;
        Preconditions.checkState((boolean)this.closed);
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        Block dictionaryElements = this.dictionary.getElementBlock();
        for (int sortedDictionaryIndex : sortedDictionaryIndexes = SliceDictionaryColumnWriter.getSortedDictionaryNullsLast(dictionaryElements)) {
            if (dictionaryElements.isNull(sortedDictionaryIndex)) continue;
            int length = dictionaryElements.getSliceLength(sortedDictionaryIndex);
            this.dictionaryLengthStream.writeLong(length);
            Slice value = dictionaryElements.getSlice(sortedDictionaryIndex, 0, length);
            this.dictionaryDataStream.writeSlice(value);
        }
        this.columnEncoding = new ColumnEncoding(this.isDwrf ? ColumnEncoding.ColumnEncodingKind.DICTIONARY : ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2, dictionaryElements.getPositionCount() - 1);
        int[] originalDictionaryToSortedIndex = new int[sortedDictionaryIndexes.length];
        int sortOrdinal = 0;
        while (sortOrdinal < sortedDictionaryIndexes.length) {
            int dictionaryIndex = sortedDictionaryIndexes[sortOrdinal];
            originalDictionaryToSortedIndex[dictionaryIndex] = sortOrdinal++;
        }
        if (!this.rowGroups.isEmpty()) {
            this.presentStream.recordCheckpoint();
            this.dataStream.recordCheckpoint();
        }
        for (DictionaryRowGroup rowGroup : this.rowGroups) {
            int position;
            IntBigArray dictionaryIndexes = rowGroup.getDictionaryIndexes();
            for (position = 0; position < rowGroup.getValueCount(); ++position) {
                this.presentStream.writeBoolean(dictionaryIndexes.get((long)position) != 0);
            }
            for (position = 0; position < rowGroup.getValueCount(); ++position) {
                int originalDictionaryIndex = dictionaryIndexes.get((long)position);
                if (originalDictionaryIndex == 0) continue;
                int sortedIndex = originalDictionaryToSortedIndex[originalDictionaryIndex];
                if (sortedIndex < 0) {
                    throw new IllegalArgumentException();
                }
                this.dataStream.writeLong(sortedIndex);
            }
            this.presentStream.recordCheckpoint();
            this.dataStream.recordCheckpoint();
        }
        this.dictionary.clear();
        this.dictionaryDataStream.close();
        this.dictionaryLengthStream.close();
        this.dataStream.close();
        this.presentStream.close();
    }

    private static int[] getSortedDictionaryNullsLast(final Block elementBlock) {
        int[] sortedPositions = new int[elementBlock.getPositionCount()];
        for (int i = 0; i < sortedPositions.length; ++i) {
            sortedPositions[i] = i;
        }
        IntArrays.quickSort((int[])sortedPositions, (int)0, (int)sortedPositions.length, (IntComparator)new AbstractIntComparator(){

            public int compare(int left, int right) {
                boolean nullLeft = elementBlock.isNull(left);
                boolean nullRight = elementBlock.isNull(right);
                if (nullLeft && nullRight) {
                    return 0;
                }
                if (nullLeft) {
                    return 1;
                }
                if (nullRight) {
                    return -1;
                }
                return elementBlock.compareTo(left, 0, elementBlock.getSliceLength(left), elementBlock, right, 0, elementBlock.getSliceLength(right));
            }
        });
        return sortedPositions;
    }

    @Override
    public List<Stream> writeIndexStreams(SliceOutput outputStream, MetadataWriter metadataWriter) throws IOException {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.directColumnWriter.writeIndexStreams(outputStream, metadataWriter);
        }
        ImmutableList.Builder rowGroupIndexes = ImmutableList.builder();
        List dataCheckpoints = this.dataStream.getCheckpoints();
        Optional<List<BooleanStreamCheckpoint>> presentCheckpoints = this.presentStream.getCheckpoints();
        for (int i = 0; i < this.rowGroups.size(); ++i) {
            int groupId = i;
            ColumnStatistics columnStatistics = this.rowGroups.get(groupId).getColumnStatistics();
            LongStreamCheckpoint dataCheckpoint = (LongStreamCheckpoint)dataCheckpoints.get(groupId);
            Optional<BooleanStreamCheckpoint> presentCheckpoint = presentCheckpoints.map(checkpoints -> (BooleanStreamCheckpoint)checkpoints.get(groupId));
            List<Integer> positions = SliceDictionaryColumnWriter.createSliceColumnPositionList(this.compression != CompressionKind.NONE, dataCheckpoint, presentCheckpoint);
            rowGroupIndexes.add((Object)new RowGroupIndex(positions, columnStatistics));
        }
        int length = metadataWriter.writeRowIndexes(outputStream, (List<RowGroupIndex>)rowGroupIndexes.build());
        return ImmutableList.of((Object)new Stream(this.column, Stream.StreamKind.ROW_INDEX, length, false));
    }

    private static List<Integer> createSliceColumnPositionList(boolean compressed, LongStreamCheckpoint dataCheckpoint, Optional<BooleanStreamCheckpoint> presentCheckpoint) {
        ImmutableList.Builder positionList = ImmutableList.builder();
        presentCheckpoint.ifPresent(booleanStreamCheckpoint -> positionList.addAll(booleanStreamCheckpoint.toPositionList(compressed)));
        positionList.addAll(dataCheckpoint.toPositionList(compressed));
        return positionList.build();
    }

    @Override
    public List<OutputDataStream> getOutputDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.directColumnWriter.getOutputDataStreams();
        }
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        outputDataStreams.add((Object)new OutputDataStream(sliceOutput -> this.presentStream.writeDataStreams(this.column, (SliceOutput)sliceOutput), this.presentStream.getBufferedBytes()));
        outputDataStreams.add((Object)new OutputDataStream(sliceOutput -> this.dataStream.writeDataStreams(this.column, (SliceOutput)sliceOutput), this.dataStream.getBufferedBytes()));
        outputDataStreams.add((Object)new OutputDataStream(sliceOutput -> this.dictionaryLengthStream.writeDataStreams(this.column, (SliceOutput)sliceOutput), this.dictionaryLengthStream.getBufferedBytes()));
        outputDataStreams.add((Object)new OutputDataStream(sliceOutput -> this.dictionaryDataStream.writeDataStreams(this.column, (SliceOutput)sliceOutput), this.dictionaryDataStream.getBufferedBytes()));
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.directEncoded) {
            return this.directColumnWriter.getBufferedBytes();
        }
        int indexBytes = DictionaryCompressionOptimizer.estimateIndexBytesPerValue(this.dictionary.getEntryCount()) * this.getNonNullValueCount();
        return indexBytes + this.getDictionaryBytes();
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.values.sizeOf() + this.dataStream.getRetainedBytes() + this.presentStream.getRetainedBytes() + this.dictionaryDataStream.getRetainedBytes() + this.dictionaryLengthStream.getRetainedBytes() + this.dictionary.getRetainedSizeInBytes() + (this.directColumnWriter == null ? 0L : this.directColumnWriter.getRetainedBytes());
    }

    @Override
    public void reset() {
        Preconditions.checkState((boolean)this.closed);
        this.closed = false;
        this.dataStream.reset();
        this.presentStream.reset();
        this.dictionaryDataStream.reset();
        this.dictionaryLengthStream.reset();
        this.rowGroups.clear();
        this.valueCount = 0;
        this.statisticsBuilder = new StringStatisticsBuilder();
        this.columnEncoding = null;
        this.dictionary.clear();
        this.rawBytes = 0L;
        if (this.directEncoded) {
            this.directEncoded = false;
            this.directColumnWriter.reset();
        }
    }

    private static class DictionaryRowGroup {
        private final IntBigArray dictionaryIndexes;
        private final int valueCount;
        private final ColumnStatistics columnStatistics;

        public DictionaryRowGroup(IntBigArray dictionaryIndexes, int valueCount, ColumnStatistics columnStatistics) {
            Objects.requireNonNull(dictionaryIndexes, "dictionaryIndexes is null");
            Preconditions.checkArgument((valueCount >= 0 ? 1 : 0) != 0, (Object)"valueCount is negative");
            Objects.requireNonNull(columnStatistics, "columnStatistics is null");
            this.dictionaryIndexes = dictionaryIndexes;
            this.valueCount = valueCount;
            this.columnStatistics = columnStatistics;
        }

        public IntBigArray getDictionaryIndexes() {
            return this.dictionaryIndexes;
        }

        public int getValueCount() {
            return this.valueCount;
        }

        public ColumnStatistics getColumnStatistics() {
            return this.columnStatistics;
        }
    }
}

