/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.cache;

import com.facebook.presto.hive.$internal.jodd.cache.AbstractCacheMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<K, V>
extends AbstractCacheMap<K, V> {
    public LRUCache(int cacheSize) {
        this(cacheSize, 0L);
    }

    public LRUCache(int cacheSize, long timeout) {
        this.cacheSize = cacheSize;
        this.timeout = timeout;
        this.cacheMap = new LinkedHashMap<K, AbstractCacheMap.CacheObject<K, V>>(cacheSize + 1, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return LRUCache.this.removeEldestEntry(this.size());
            }
        };
    }

    protected boolean removeEldestEntry(int currentSize) {
        if (this.cacheSize == 0) {
            return false;
        }
        return currentSize > this.cacheSize;
    }

    @Override
    protected int pruneCache() {
        if (!this.isPruneExpiredActive()) {
            return 0;
        }
        int count = 0;
        Iterator values = this.cacheMap.values().iterator();
        while (values.hasNext()) {
            AbstractCacheMap.CacheObject co = (AbstractCacheMap.CacheObject)values.next();
            if (!co.isExpired()) continue;
            values.remove();
            ++count;
        }
        return count;
    }
}

