/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lockmgr;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.lockmgr.HiveLock;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManager;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockManagerCtx;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockMode;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObj;
import org.apache.hadoop.hive.ql.lockmgr.HiveLockObject;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.thrift.TException;

public class DbLockManager
implements HiveLockManager {
    private static final String CLASS_NAME = DbLockManager.class.getName();
    private static final Log LOG = LogFactory.getLog(CLASS_NAME);
    private static final long MAX_SLEEP = 15000L;
    private HiveLockManagerCtx context;
    private Set<DbHiveLock> locks = new HashSet<DbHiveLock>();
    private IMetaStoreClient client;
    private long nextSleep = 50L;

    DbLockManager(IMetaStoreClient client) {
        this.client = client;
    }

    @Override
    public void setContext(HiveLockManagerCtx ctx) throws LockException {
        this.context = ctx;
    }

    @Override
    public HiveLock lock(HiveLockObject key, HiveLockMode mode, boolean keepAlive) throws LockException {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<HiveLock> lock(List<HiveLockObj> objs, boolean keepAlive) throws LockException {
        throw new UnsupportedOperationException();
    }

    LockState lock(LockRequest lock2, String queryId, boolean isBlocking, List<HiveLock> acquiredLocks) throws LockException {
        try {
            LOG.debug("Requesting: queryId=" + queryId + " " + lock2);
            LockResponse res = this.client.lock(lock2);
            LOG.debug("Response " + res);
            if (!isBlocking && res.getState() == LockState.WAITING) {
                return LockState.WAITING;
            }
            while (res.getState() == LockState.WAITING) {
                this.backoff();
                res = this.client.checkLock(res.getLockid());
            }
            DbHiveLock hl = new DbHiveLock(res.getLockid());
            this.locks.add(hl);
            if (res.getState() != LockState.ACQUIRED) {
                throw new LockException(ErrorMsg.LOCK_CANNOT_BE_ACQUIRED.getMsg());
            }
            acquiredLocks.add(hl);
            return res.getState();
        }
        catch (NoSuchTxnException e) {
            LOG.error("Metastore could not find txnid " + lock2.getTxnid());
            throw new LockException(ErrorMsg.TXNMGR_NOT_INSTANTIATED.getMsg(), (Throwable)((Object)e));
        }
        catch (TxnAbortedException e) {
            LOG.error("Transaction " + lock2.getTxnid() + " already aborted.");
            throw new LockException(ErrorMsg.TXN_ABORTED.getMsg(), (Throwable)((Object)e));
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    LockState checkLock(long extLockId) throws LockException {
        try {
            return this.client.checkLock(extLockId).getState();
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    @Override
    public void unlock(HiveLock hiveLock) throws LockException {
        long lockId = ((DbHiveLock)hiveLock).lockId;
        try {
            LOG.debug("Unlocking " + hiveLock);
            this.client.unlock(lockId);
            boolean removed = this.locks.remove(hiveLock);
            LOG.debug("Removed a lock " + removed);
        }
        catch (NoSuchLockException e) {
            LOG.error("Metastore could find no record of lock " + lockId);
            throw new LockException(ErrorMsg.LOCK_NO_SUCH_LOCK.getMsg(), (Throwable)((Object)e));
        }
        catch (TxnOpenException e) {
            throw new RuntimeException("Attempt to unlock lock " + lockId + "associated with an open transaction, " + e.getMessage(), (Throwable)((Object)e));
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    @Override
    public void releaseLocks(List<HiveLock> hiveLocks) {
        for (HiveLock lock2 : hiveLocks) {
            try {
                this.unlock(lock2);
            }
            catch (LockException e) {}
        }
    }

    @Override
    public List<HiveLock> getLocks(boolean verifyTablePartitions, boolean fetchData) throws LockException {
        return new ArrayList<HiveLock>(this.locks);
    }

    @Override
    public List<HiveLock> getLocks(HiveLockObject key, boolean verifyTablePartitions, boolean fetchData) throws LockException {
        throw new UnsupportedOperationException();
    }

    public ShowLocksResponse getLocks() throws LockException {
        try {
            return this.client.showLocks();
        }
        catch (TException e) {
            throw new LockException(ErrorMsg.METASTORE_COMMUNICATION_FAILED.getMsg(), e);
        }
    }

    @Override
    public void close() throws LockException {
        for (HiveLock hiveLock : this.locks) {
            this.unlock(hiveLock);
        }
        this.locks.clear();
    }

    @Override
    public void prepareRetry() throws LockException {
    }

    @Override
    public void refresh() {
    }

    void clearLocalLockRecords() {
        this.locks.clear();
    }

    private void backoff() {
        this.nextSleep *= 2L;
        if (this.nextSleep > 15000L) {
            this.nextSleep = 15000L;
        }
        try {
            Thread.sleep(this.nextSleep);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class DbHiveLock
    extends HiveLock {
        long lockId;

        DbHiveLock(long id) {
            this.lockId = id;
        }

        @Override
        public HiveLockObject getHiveLockObject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public HiveLockMode getHiveLockMode() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object other) {
            if (other instanceof DbHiveLock) {
                return this.lockId == ((DbHiveLock)other).lockId;
            }
            return false;
        }

        public int hashCode() {
            return (int)(this.lockId % Integer.MAX_VALUE);
        }

        public String toString() {
            return JavaUtils.lockIdToString(this.lockId);
        }
    }
}

