/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.index;

import com.facebook.presto.hive.$internal.org.apache.commons.logging.Log;
import com.facebook.presto.hive.$internal.org.apache.commons.logging.LogFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.PreOrderWalker;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.index.RewriteCanApplyProcFactory;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.util.StringUtils;

public final class RewriteCanApplyCtx
implements NodeProcessorCtx {
    private static final Log LOG = LogFactory.getLog(RewriteCanApplyCtx.class.getName());
    private boolean selClauseColsFetchException = false;
    private boolean queryHasGroupBy = false;
    private boolean aggFuncIsNotCount = false;
    private boolean aggParameterException = false;
    private String indexKey;
    private final ParseContext parseContext;
    private String alias;
    private String baseTableName;
    private String indexTableName;
    private String aggFunction;
    private TableScanOperator tableScanOperator;
    private List<SelectOperator> selectOperators;
    private List<GroupByOperator> groupByOperators;
    private final Map<String, String> baseToIdxTableMap = new HashMap<String, String>();

    private RewriteCanApplyCtx(ParseContext parseContext) {
        this.parseContext = parseContext;
    }

    public static RewriteCanApplyCtx getInstance(ParseContext parseContext) {
        return new RewriteCanApplyCtx(parseContext);
    }

    void resetCanApplyCtx() {
        this.setQueryHasGroupBy(false);
        this.setAggFuncIsNotCount(false);
        this.setSelClauseColsFetchException(false);
        this.setBaseTableName("");
        this.setAggFunction("");
        this.setIndexKey("");
    }

    public boolean isQueryHasGroupBy() {
        return this.queryHasGroupBy;
    }

    public void setQueryHasGroupBy(boolean queryHasGroupBy) {
        this.queryHasGroupBy = queryHasGroupBy;
    }

    public boolean isAggFuncIsNotCount() {
        return this.aggFuncIsNotCount;
    }

    public void setAggFuncIsNotCount(boolean aggFuncIsNotCount) {
        this.aggFuncIsNotCount = aggFuncIsNotCount;
    }

    public Map<String, String> getBaseToIdxTableMap() {
        return this.baseToIdxTableMap;
    }

    public void setAggFunction(String aggFunction) {
        this.aggFunction = aggFunction;
    }

    public String getAggFunction() {
        return this.aggFunction;
    }

    public void setSelClauseColsFetchException(boolean selClauseColsFetchException) {
        this.selClauseColsFetchException = selClauseColsFetchException;
    }

    public boolean isSelClauseColsFetchException() {
        return this.selClauseColsFetchException;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public void setBaseTableName(String baseTableName) {
        this.baseTableName = baseTableName;
    }

    public String getIndexTableName() {
        return this.indexTableName;
    }

    public void setIndexTableName(String indexTableName) {
        this.indexTableName = indexTableName;
    }

    public ParseContext getParseContext() {
        return this.parseContext;
    }

    void populateRewriteVars(TableScanOperator topOp) throws SemanticException {
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + "%[(" + SelectOperator.getOperatorName() + "%)|(" + FilterOperator.getOperatorName() + "%)]*" + GroupByOperator.getOperatorName() + "%[" + FilterOperator.getOperatorName() + "%]*" + ReduceSinkOperator.getOperatorName() + "%[" + FilterOperator.getOperatorName() + "%]*" + GroupByOperator.getOperatorName() + "%"), RewriteCanApplyProcFactory.canApplyOnTableScanOperator(topOp));
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(this.getDefaultProc(), opRules, this);
        PreOrderWalker ogw = new PreOrderWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.add(topOp);
        try {
            ogw.startWalking(topNodes, null);
        }
        catch (SemanticException e) {
            LOG.error("Exception in walking operator tree. Rewrite variables not populated");
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new SemanticException(e.getMessage(), e);
        }
    }

    private NodeProcessor getDefaultProc() {
        return new NodeProcessor(){

            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                return null;
            }
        };
    }

    public void addTable(String baseTableName, String indexTableName) {
        this.baseToIdxTableMap.put(baseTableName, indexTableName);
    }

    public String findBaseTable(String baseTableName) {
        return this.baseToIdxTableMap.get(baseTableName);
    }

    public String getIndexKey() {
        return this.indexKey;
    }

    public void setIndexKey(String indexKey) {
        this.indexKey = indexKey;
    }

    public TableScanOperator getTableScanOperator() {
        return this.tableScanOperator;
    }

    public void setTableScanOperator(TableScanOperator tableScanOperator) {
        this.tableScanOperator = tableScanOperator;
    }

    public List<SelectOperator> getSelectOperators() {
        return this.selectOperators;
    }

    public void setSelectOperators(List<SelectOperator> selectOperators) {
        this.selectOperators = selectOperators;
    }

    public List<GroupByOperator> getGroupByOperators() {
        return this.groupByOperators;
    }

    public void setGroupByOperators(List<GroupByOperator> groupByOperators) {
        this.groupByOperators = groupByOperators;
    }

    public void setAggParameterException(boolean aggParameterException) {
        this.aggParameterException = aggParameterException;
    }

    public boolean isAggParameterException() {
        return this.aggParameterException;
    }
}

