/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.ptf;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.PTFDesc;
import org.apache.hadoop.hive.ql.plan.ptf.PartitionedTableFunctionDef;
import org.apache.hadoop.hive.ql.udf.ptf.NoopStreaming;
import org.apache.hadoop.hive.ql.udf.ptf.NoopWithMap;
import org.apache.hadoop.hive.ql.udf.ptf.TableFunctionEvaluator;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class NoopWithMapStreaming
extends NoopWithMap {
    List<Object> rows = new ArrayList<Object>();
    StructObjectInspector inputOI;

    NoopWithMapStreaming() {
    }

    @Override
    public void initializeStreaming(Configuration cfg, StructObjectInspector inputOI, boolean isMapSide) throws HiveException {
        this.inputOI = inputOI;
        this.canAcceptInputAsStream = true;
    }

    @Override
    public List<Object> processRow(Object row) throws HiveException {
        if (!this.canAcceptInputAsStream()) {
            throw new HiveException(String.format("Internal error: PTF %s, doesn't support Streaming", this.getClass().getName()));
        }
        this.rows.clear();
        row = ObjectInspectorUtils.copyToStandardObject(row, this.inputOI, ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        this.rows.add(row);
        return this.rows;
    }

    public static class NoopWithMapStreamingResolver
    extends NoopWithMap.NoopWithMapResolver {
        @Override
        protected TableFunctionEvaluator createEvaluator(PTFDesc ptfDesc, PartitionedTableFunctionDef tDef) {
            return new NoopStreaming();
        }
    }
}

