/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.mapreduce;

import com.facebook.presto.hive.$internal.org.apache.commons.lang.StringUtils;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.hcatalog.common.HCatUtil;

public class MultiOutputFormat
extends OutputFormat<Writable, Writable> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiOutputFormat.class.getName());
    private static final String MO_ALIASES = "mapreduce.multiout.aliases";
    private static final String MO_ALIAS = "mapreduce.multiout.alias";
    private static final String CONF_KEY_DELIM = "%%";
    private static final String CONF_VALUE_DELIM = ";;";
    private static final String COMMA_DELIM = ",";
    private static final List<String> configsToOverride = new ArrayList<String>();
    private static final Map<String, String> configsToMerge = new HashMap<String, String>();

    public static JobConfigurer createConfigurer(Job job) {
        return JobConfigurer.create(job);
    }

    public static JobContext getJobContext(String alias, JobContext context) {
        String aliasConf = context.getConfiguration().get(MultiOutputFormat.getAliasConfName(alias));
        JobContext aliasContext = ShimLoader.getHadoopShims().getHCatShim().createJobContext(context.getConfiguration(), context.getJobID());
        MultiOutputFormat.addToConfig(aliasConf, aliasContext.getConfiguration());
        return aliasContext;
    }

    public static TaskAttemptContext getTaskAttemptContext(String alias, TaskAttemptContext context) {
        String aliasConf = context.getConfiguration().get(MultiOutputFormat.getAliasConfName(alias));
        TaskAttemptContext aliasContext = ShimLoader.getHadoopShims().getHCatShim().createTaskAttemptContext(context.getConfiguration(), context.getTaskAttemptID());
        MultiOutputFormat.addToConfig(aliasConf, aliasContext.getConfiguration());
        return aliasContext;
    }

    public static <K, V> void write(String alias, K key, V value, TaskInputOutputContext context) throws IOException, InterruptedException {
        KeyValue<K, V> keyval = new KeyValue<K, V>(key, value);
        context.write((Object)new Text(alias), keyval);
    }

    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        for (String alias : MultiOutputFormat.getOutputFormatAliases(context)) {
            LOGGER.debug("Calling checkOutputSpecs for alias: " + alias);
            JobContext aliasContext = MultiOutputFormat.getJobContext(alias, context);
            OutputFormat<?, ?> outputFormat = MultiOutputFormat.getOutputFormatInstance(aliasContext);
            outputFormat.checkOutputSpecs(aliasContext);
            context.getCredentials().addAll(aliasContext.getCredentials());
            MultiOutputFormat.setAliasConf(alias, context, aliasContext);
        }
    }

    public RecordWriter<Writable, Writable> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new MultiRecordWriter(context);
    }

    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new MultiOutputCommitter(context);
    }

    private static OutputFormat<?, ?> getOutputFormatInstance(JobContext context) {
        OutputFormat outputFormat;
        try {
            outputFormat = (OutputFormat)ReflectionUtils.newInstance((Class)context.getOutputFormatClass(), (Configuration)context.getConfiguration());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
        return outputFormat;
    }

    private static String[] getOutputFormatAliases(JobContext context) {
        return context.getConfiguration().getStrings(MO_ALIASES);
    }

    private static void setAliasConf(String alias, JobContext userJob, JobContext aliasContext) {
        Configuration userConf = userJob.getConfiguration();
        StringBuilder builder = new StringBuilder();
        for (Map.Entry conf : aliasContext.getConfiguration()) {
            String key = (String)conf.getKey();
            String value = (String)conf.getValue();
            String jobValue = userConf.getRaw(key);
            if (jobValue != null && jobValue.equals(value)) continue;
            if (configsToMerge.containsKey(key)) {
                String mergedValue = MultiOutputFormat.getMergedConfValue(jobValue, value, configsToMerge.get(key));
                userConf.set(key, mergedValue);
                continue;
            }
            if (configsToOverride.contains(key)) {
                userConf.set(key, value);
            }
            builder.append(key).append(CONF_KEY_DELIM).append(value).append(CONF_VALUE_DELIM);
        }
        if (builder.length() > CONF_VALUE_DELIM.length()) {
            builder.delete(builder.length() - CONF_VALUE_DELIM.length(), builder.length());
            userConf.set(MultiOutputFormat.getAliasConfName(alias), builder.toString());
        }
    }

    private static String getMergedConfValue(String originalValues, String newValues, String separator) {
        if (originalValues == null) {
            return newValues;
        }
        LinkedHashSet<String> mergedValues = new LinkedHashSet<String>();
        mergedValues.addAll(Arrays.asList(StringUtils.split(originalValues, separator)));
        mergedValues.addAll(Arrays.asList(StringUtils.split(newValues, separator)));
        StringBuilder builder = new StringBuilder(originalValues.length() + newValues.length() + 2);
        for (String value : mergedValues) {
            builder.append(value).append(separator);
        }
        return builder.substring(0, builder.length() - separator.length());
    }

    private static String getAliasConfName(String alias) {
        return "mapreduce.multiout.alias." + alias + ".conf";
    }

    private static void addToConfig(String aliasConf, Configuration conf) {
        String[] config = aliasConf.split("%%|;;");
        for (int i = 0; i < config.length; i += 2) {
            conf.set(config[i], config[i + 1]);
        }
    }

    static {
        configsToOverride.add("mapred.output.dir");
        configsToOverride.add(ShimLoader.getHadoopShims().getHCatShim().getPropertyName(HadoopShims.HCatHadoopShims.PropertyName.CACHE_SYMLINK));
        configsToMerge.put("mapreduce.job.hdfs-servers", COMMA_DELIM);
        configsToMerge.put("tmpfiles", COMMA_DELIM);
        configsToMerge.put("tmpjars", COMMA_DELIM);
        configsToMerge.put("tmparchives", COMMA_DELIM);
        configsToMerge.put(ShimLoader.getHadoopShims().getHCatShim().getPropertyName(HadoopShims.HCatHadoopShims.PropertyName.CACHE_ARCHIVES), COMMA_DELIM);
        configsToMerge.put(ShimLoader.getHadoopShims().getHCatShim().getPropertyName(HadoopShims.HCatHadoopShims.PropertyName.CACHE_FILES), COMMA_DELIM);
        String fileSep = HCatUtil.isHadoop23() ? COMMA_DELIM : System.getProperty("path.separator");
        configsToMerge.put(ShimLoader.getHadoopShims().getHCatShim().getPropertyName(HadoopShims.HCatHadoopShims.PropertyName.CLASSPATH_ARCHIVES), fileSep);
        configsToMerge.put(ShimLoader.getHadoopShims().getHCatShim().getPropertyName(HadoopShims.HCatHadoopShims.PropertyName.CLASSPATH_FILES), fileSep);
    }

    private static class BaseOutputCommitterContainer {
        private final OutputCommitter outputCommitter;
        private final TaskAttemptContext context;

        public BaseOutputCommitterContainer(OutputCommitter outputCommitter, TaskAttemptContext context) {
            this.outputCommitter = outputCommitter;
            this.context = context;
        }

        public OutputCommitter getBaseCommitter() {
            return this.outputCommitter;
        }

        public TaskAttemptContext getContext() {
            return this.context;
        }
    }

    public class MultiOutputCommitter
    extends OutputCommitter {
        private final Map<String, BaseOutputCommitterContainer> outputCommitters = new LinkedHashMap<String, BaseOutputCommitterContainer>();

        public MultiOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
            String[] aliases;
            for (String alias : aliases = MultiOutputFormat.getOutputFormatAliases((JobContext)context)) {
                LOGGER.info("Creating output committer for alias: " + alias);
                TaskAttemptContext aliasContext = MultiOutputFormat.getTaskAttemptContext(alias, context);
                OutputCommitter baseCommitter = MultiOutputFormat.getOutputFormatInstance((JobContext)aliasContext).getOutputCommitter(aliasContext);
                this.outputCommitters.put(alias, new BaseOutputCommitterContainer(baseCommitter, aliasContext));
            }
        }

        public void setupJob(JobContext jobContext) throws IOException {
            for (String alias : this.outputCommitters.keySet()) {
                LOGGER.info("Calling setupJob for alias: " + alias);
                BaseOutputCommitterContainer outputContainer = this.outputCommitters.get(alias);
                outputContainer.getBaseCommitter().setupJob((JobContext)outputContainer.getContext());
            }
        }

        public void setupTask(TaskAttemptContext taskContext) throws IOException {
            for (String alias : this.outputCommitters.keySet()) {
                LOGGER.info("Calling setupTask for alias: " + alias);
                BaseOutputCommitterContainer outputContainer = this.outputCommitters.get(alias);
                outputContainer.getBaseCommitter().setupTask(outputContainer.getContext());
            }
        }

        public boolean needsTaskCommit(TaskAttemptContext taskContext) throws IOException {
            boolean needTaskCommit = false;
            for (String alias : this.outputCommitters.keySet()) {
                BaseOutputCommitterContainer outputContainer = this.outputCommitters.get(alias);
                needTaskCommit = needTaskCommit || outputContainer.getBaseCommitter().needsTaskCommit(outputContainer.getContext());
            }
            return needTaskCommit;
        }

        public void commitTask(TaskAttemptContext taskContext) throws IOException {
            for (String alias : this.outputCommitters.keySet()) {
                TaskAttemptContext committerContext;
                BaseOutputCommitterContainer outputContainer = this.outputCommitters.get(alias);
                OutputCommitter baseCommitter = outputContainer.getBaseCommitter();
                if (!baseCommitter.needsTaskCommit(committerContext = outputContainer.getContext())) continue;
                LOGGER.info("Calling commitTask for alias: " + alias);
                baseCommitter.commitTask(committerContext);
            }
        }

        public void abortTask(TaskAttemptContext taskContext) throws IOException {
            for (String alias : this.outputCommitters.keySet()) {
                LOGGER.info("Calling abortTask for alias: " + alias);
                BaseOutputCommitterContainer outputContainer = this.outputCommitters.get(alias);
                outputContainer.getBaseCommitter().abortTask(outputContainer.getContext());
            }
        }

        public void commitJob(JobContext jobContext) throws IOException {
            for (String alias : this.outputCommitters.keySet()) {
                LOGGER.info("Calling commitJob for alias: " + alias);
                BaseOutputCommitterContainer outputContainer = this.outputCommitters.get(alias);
                outputContainer.getBaseCommitter().commitJob((JobContext)outputContainer.getContext());
            }
        }

        public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
            for (String alias : this.outputCommitters.keySet()) {
                LOGGER.info("Calling abortJob for alias: " + alias);
                BaseOutputCommitterContainer outputContainer = this.outputCommitters.get(alias);
                outputContainer.getBaseCommitter().abortJob((JobContext)outputContainer.getContext(), state);
            }
        }
    }

    private static class BaseRecordWriterContainer {
        private final RecordWriter recordWriter;
        private final TaskAttemptContext context;

        public BaseRecordWriterContainer(RecordWriter recordWriter, TaskAttemptContext context) {
            this.recordWriter = recordWriter;
            this.context = context;
        }

        public RecordWriter getRecordWriter() {
            return this.recordWriter;
        }

        public TaskAttemptContext getContext() {
            return this.context;
        }
    }

    private static class MultiRecordWriter
    extends RecordWriter<Writable, Writable> {
        private final Map<String, BaseRecordWriterContainer> baseRecordWriters = new LinkedHashMap<String, BaseRecordWriterContainer>();

        public MultiRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
            String[] aliases;
            for (String alias : aliases = MultiOutputFormat.getOutputFormatAliases((JobContext)context)) {
                Path outputDir;
                FileSystem fs;
                LOGGER.info("Creating record writer for alias: " + alias);
                TaskAttemptContext aliasContext = MultiOutputFormat.getTaskAttemptContext(alias, context);
                Configuration aliasConf = aliasContext.getConfiguration();
                String outDir = aliasConf.get("mapred.output.dir");
                if (outDir != null && !(fs = (outputDir = new Path(outDir)).getFileSystem(aliasConf)).exists(outputDir)) {
                    fs.mkdirs(outputDir);
                }
                OutputFormat outputFormat = MultiOutputFormat.getOutputFormatInstance((JobContext)aliasContext);
                this.baseRecordWriters.put(alias, new BaseRecordWriterContainer(outputFormat.getRecordWriter(aliasContext), aliasContext));
            }
        }

        public void write(Writable key, Writable value) throws IOException, InterruptedException {
            Text _key = (Text)key;
            KeyValue _value = (KeyValue)value;
            String alias = new String(_key.getBytes(), 0, _key.getLength());
            BaseRecordWriterContainer baseRWContainer = this.baseRecordWriters.get(alias);
            if (baseRWContainer == null) {
                throw new IllegalArgumentException("OutputFormat with alias " + alias + " has not been added");
            }
            baseRWContainer.getRecordWriter().write(_value.getKey(), _value.getValue());
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            for (Map.Entry<String, BaseRecordWriterContainer> entry : this.baseRecordWriters.entrySet()) {
                BaseRecordWriterContainer baseRWContainer = entry.getValue();
                LOGGER.info("Closing record writer for alias: " + entry.getKey());
                baseRWContainer.getRecordWriter().close(baseRWContainer.getContext());
            }
        }
    }

    private static class KeyValue<K, V>
    implements Writable {
        private final K key;
        private final V value;

        public KeyValue(K key, V value) {
            this.key = key;
            this.value = value;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public void write(DataOutput out) throws IOException {
        }

        public void readFields(DataInput in) throws IOException {
        }
    }

    public static class JobConfigurer {
        private final Job job;
        private Map<String, Job> outputConfigs = new LinkedHashMap<String, Job>();

        private JobConfigurer(Job job) {
            this.job = job;
        }

        private static JobConfigurer create(Job job) {
            JobConfigurer configurer = new JobConfigurer(job);
            return configurer;
        }

        public void addOutputFormat(String alias, Class<? extends OutputFormat> outputFormatClass, Class<?> keyClass, Class<?> valueClass) throws IOException {
            Job copy = new Job(this.job.getConfiguration());
            this.outputConfigs.put(alias, copy);
            copy.setOutputFormatClass(outputFormatClass);
            copy.setOutputKeyClass(keyClass);
            copy.setOutputValueClass(valueClass);
        }

        public Job getJob(String alias) {
            Job copy = this.outputConfigs.get(alias);
            if (copy == null) {
                throw new IllegalArgumentException("OutputFormat with alias " + alias + " has not beed added");
            }
            return copy;
        }

        public void configure() {
            StringBuilder aliases = new StringBuilder();
            Configuration jobConf = this.job.getConfiguration();
            for (Map.Entry<String, Job> entry : this.outputConfigs.entrySet()) {
                this.job.getCredentials().addAll(entry.getValue().getCredentials());
                String alias = entry.getKey();
                aliases.append(alias).append(MultiOutputFormat.COMMA_DELIM);
                MultiOutputFormat.setAliasConf(alias, (JobContext)this.job, (JobContext)entry.getValue());
            }
            aliases.delete(aliases.length() - MultiOutputFormat.COMMA_DELIM.length(), aliases.length());
            jobConf.set(MultiOutputFormat.MO_ALIASES, aliases.toString());
        }
    }
}

